/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ConfigurationRecorder;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConfigurationRecorderMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleARN").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RECORDINGGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recordingGroup").isBinary(false).build();
    private static final ConfigurationRecorderMarshaller INSTANCE = new ConfigurationRecorderMarshaller();

    private ConfigurationRecorderMarshaller() {
    }

    public static ConfigurationRecorderMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConfigurationRecorder configurationRecorder, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)configurationRecorder, (String)"configurationRecorder");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)configurationRecorder.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)configurationRecorder.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)configurationRecorder.recordingGroup(), RECORDINGGROUP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

