/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.ConfigStreamDeliveryInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConfigStreamDeliveryInfoMarshaller {
    private static final MarshallingInfo<String> LASTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStatus").isBinary(false).build();
    private static final MarshallingInfo<String> LASTERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastErrorCode").isBinary(false).build();
    private static final MarshallingInfo<String> LASTERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastErrorMessage").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTSTATUSCHANGETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStatusChangeTime").isBinary(false).build();
    private static final ConfigStreamDeliveryInfoMarshaller INSTANCE = new ConfigStreamDeliveryInfoMarshaller();

    private ConfigStreamDeliveryInfoMarshaller() {
    }

    public static ConfigStreamDeliveryInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConfigStreamDeliveryInfo configStreamDeliveryInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)configStreamDeliveryInfo, (String)"configStreamDeliveryInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)configStreamDeliveryInfo.lastStatusAsString(), LASTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)configStreamDeliveryInfo.lastErrorCode(), LASTERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)configStreamDeliveryInfo.lastErrorMessage(), LASTERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)configStreamDeliveryInfo.lastStatusChangeTime(), LASTSTATUSCHANGETIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

