/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ComplianceSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ComplianceSummaryMarshaller {
    private static final MarshallingInfo<StructuredPojo> COMPLIANTRESOURCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompliantResourceCount").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NONCOMPLIANTRESOURCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NonCompliantResourceCount").isBinary(false).build();
    private static final MarshallingInfo<Instant> COMPLIANCESUMMARYTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceSummaryTimestamp").isBinary(false).build();
    private static final ComplianceSummaryMarshaller INSTANCE = new ComplianceSummaryMarshaller();

    private ComplianceSummaryMarshaller() {
    }

    public static ComplianceSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ComplianceSummary complianceSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)complianceSummary, (String)"complianceSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)complianceSummary.compliantResourceCount(), COMPLIANTRESOURCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)complianceSummary.nonCompliantResourceCount(), NONCOMPLIANTRESOURCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)complianceSummary.complianceSummaryTimestamp(), COMPLIANCESUMMARYTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

