/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ConfigurationRecorderNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationRecorderStatusRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, DescribeConfigurationRecorderStatusRequest> {
    private final List<String> configurationRecorderNames;

    private DescribeConfigurationRecorderStatusRequest(BuilderImpl builder) {
        super(builder);
        this.configurationRecorderNames = builder.configurationRecorderNames;
    }

    public List<String> configurationRecorderNames() {
        return this.configurationRecorderNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationRecorderNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRecorderStatusRequest)) {
            return false;
        }
        DescribeConfigurationRecorderStatusRequest other = (DescribeConfigurationRecorderStatusRequest)((Object)obj);
        return Objects.equals(this.configurationRecorderNames(), other.configurationRecorderNames());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConfigurationRecorderStatusRequest").add("ConfigurationRecorderNames", this.configurationRecorderNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationRecorderNames": {
                return Optional.ofNullable(clazz.cast(this.configurationRecorderNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private List<String> configurationRecorderNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRecorderStatusRequest model) {
            super(model);
            this.configurationRecorderNames(model.configurationRecorderNames);
        }

        public final Collection<String> getConfigurationRecorderNames() {
            return this.configurationRecorderNames;
        }

        @Override
        public final Builder configurationRecorderNames(Collection<String> configurationRecorderNames) {
            this.configurationRecorderNames = ConfigurationRecorderNameListCopier.copy(configurationRecorderNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecorderNames(String ... configurationRecorderNames) {
            this.configurationRecorderNames(Arrays.asList(configurationRecorderNames));
            return this;
        }

        public final void setConfigurationRecorderNames(Collection<String> configurationRecorderNames) {
            this.configurationRecorderNames = ConfigurationRecorderNameListCopier.copy(configurationRecorderNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationRecorderStatusRequest build() {
            return new DescribeConfigurationRecorderStatusRequest(this);
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    CopyableBuilder<Builder, DescribeConfigurationRecorderStatusRequest> {
        public Builder configurationRecorderNames(Collection<String> var1);

        public Builder configurationRecorderNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

