/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ConfigRuleState;
import software.amazon.awssdk.services.config.model.MaximumExecutionFrequency;
import software.amazon.awssdk.services.config.model.Scope;
import software.amazon.awssdk.services.config.model.Source;
import software.amazon.awssdk.services.config.transform.ConfigRuleMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigRule
implements StructuredPojo,
ToCopyableBuilder<Builder, ConfigRule> {
    private final String configRuleName;
    private final String configRuleArn;
    private final String configRuleId;
    private final String description;
    private final Scope scope;
    private final Source source;
    private final String inputParameters;
    private final String maximumExecutionFrequency;
    private final String configRuleState;

    private ConfigRule(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.configRuleArn = builder.configRuleArn;
        this.configRuleId = builder.configRuleId;
        this.description = builder.description;
        this.scope = builder.scope;
        this.source = builder.source;
        this.inputParameters = builder.inputParameters;
        this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
        this.configRuleState = builder.configRuleState;
    }

    public String configRuleName() {
        return this.configRuleName;
    }

    public String configRuleArn() {
        return this.configRuleArn;
    }

    public String configRuleId() {
        return this.configRuleId;
    }

    public String description() {
        return this.description;
    }

    public Scope scope() {
        return this.scope;
    }

    public Source source() {
        return this.source;
    }

    public String inputParameters() {
        return this.inputParameters;
    }

    public MaximumExecutionFrequency maximumExecutionFrequency() {
        return MaximumExecutionFrequency.fromValue(this.maximumExecutionFrequency);
    }

    public String maximumExecutionFrequencyAsString() {
        return this.maximumExecutionFrequency;
    }

    public ConfigRuleState configRuleState() {
        return ConfigRuleState.fromValue(this.configRuleState);
    }

    public String configRuleStateAsString() {
        return this.configRuleState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumExecutionFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleStateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigRule)) {
            return false;
        }
        ConfigRule other = (ConfigRule)obj;
        return Objects.equals(this.configRuleName(), other.configRuleName()) && Objects.equals(this.configRuleArn(), other.configRuleArn()) && Objects.equals(this.configRuleId(), other.configRuleId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.scope(), other.scope()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.inputParameters(), other.inputParameters()) && Objects.equals(this.maximumExecutionFrequencyAsString(), other.maximumExecutionFrequencyAsString()) && Objects.equals(this.configRuleStateAsString(), other.configRuleStateAsString());
    }

    public String toString() {
        return ToString.builder((String)"ConfigRule").add("ConfigRuleName", (Object)this.configRuleName()).add("ConfigRuleArn", (Object)this.configRuleArn()).add("ConfigRuleId", (Object)this.configRuleId()).add("Description", (Object)this.description()).add("Scope", (Object)this.scope()).add("Source", (Object)this.source()).add("InputParameters", (Object)this.inputParameters()).add("MaximumExecutionFrequency", (Object)this.maximumExecutionFrequencyAsString()).add("ConfigRuleState", (Object)this.configRuleStateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.configRuleName()));
            }
            case "ConfigRuleArn": {
                return Optional.ofNullable(clazz.cast(this.configRuleArn()));
            }
            case "ConfigRuleId": {
                return Optional.ofNullable(clazz.cast(this.configRuleId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "InputParameters": {
                return Optional.ofNullable(clazz.cast(this.inputParameters()));
            }
            case "MaximumExecutionFrequency": {
                return Optional.ofNullable(clazz.cast(this.maximumExecutionFrequencyAsString()));
            }
            case "ConfigRuleState": {
                return Optional.ofNullable(clazz.cast(this.configRuleStateAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String configRuleName;
        private String configRuleArn;
        private String configRuleId;
        private String description;
        private Scope scope;
        private Source source;
        private String inputParameters;
        private String maximumExecutionFrequency;
        private String configRuleState;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigRule model) {
            this.configRuleName(model.configRuleName);
            this.configRuleArn(model.configRuleArn);
            this.configRuleId(model.configRuleId);
            this.description(model.description);
            this.scope(model.scope);
            this.source(model.source);
            this.inputParameters(model.inputParameters);
            this.maximumExecutionFrequency(model.maximumExecutionFrequency);
            this.configRuleState(model.configRuleState);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getConfigRuleArn() {
            return this.configRuleArn;
        }

        @Override
        public final Builder configRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
            return this;
        }

        public final void setConfigRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
        }

        public final String getConfigRuleId() {
            return this.configRuleId;
        }

        @Override
        public final Builder configRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
            return this;
        }

        public final void setConfigRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Scope.Builder getScope() {
            return this.scope != null ? this.scope.toBuilder() : null;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public final void setScope(Scope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        public final Source.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final String getInputParameters() {
            return this.inputParameters;
        }

        @Override
        public final Builder inputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
            return this;
        }

        public final void setInputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
        }

        public final String getMaximumExecutionFrequency() {
            return this.maximumExecutionFrequency;
        }

        @Override
        public final Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        @Override
        public final Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency(maximumExecutionFrequency.toString());
            return this;
        }

        public final void setMaximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
        }

        public final String getConfigRuleState() {
            return this.configRuleState;
        }

        @Override
        public final Builder configRuleState(String configRuleState) {
            this.configRuleState = configRuleState;
            return this;
        }

        @Override
        public final Builder configRuleState(ConfigRuleState configRuleState) {
            this.configRuleState(configRuleState.toString());
            return this;
        }

        public final void setConfigRuleState(String configRuleState) {
            this.configRuleState = configRuleState;
        }

        public ConfigRule build() {
            return new ConfigRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigRule> {
        public Builder configRuleName(String var1);

        public Builder configRuleArn(String var1);

        public Builder configRuleId(String var1);

        public Builder description(String var1);

        public Builder scope(Scope var1);

        default public Builder scope(Consumer<Scope.Builder> scope) {
            return this.scope((Scope)((Scope.Builder)Scope.builder().applyMutation(scope)).build());
        }

        public Builder source(Source var1);

        default public Builder source(Consumer<Source.Builder> source) {
            return this.source((Source)((Source.Builder)Source.builder().applyMutation(source)).build());
        }

        public Builder inputParameters(String var1);

        public Builder maximumExecutionFrequency(String var1);

        public Builder maximumExecutionFrequency(MaximumExecutionFrequency var1);

        public Builder configRuleState(String var1);

        public Builder configRuleState(ConfigRuleState var1);
    }
}

