/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.Source;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SourceMarshaller {
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Owner").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceIdentifier").isBinary(false).build();
    private static final MarshallingInfo<List> SOURCEDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceDetails").isBinary(false).build();
    private static final SourceMarshaller INSTANCE = new SourceMarshaller();

    private SourceMarshaller() {
    }

    public static SourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Source source, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)source, (String)"source");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)source.ownerAsString(), OWNER_BINDING);
            protocolMarshaller.marshall((Object)source.sourceIdentifier(), SOURCEIDENTIFIER_BINDING);
            protocolMarshaller.marshall(source.sourceDetails(), SOURCEDETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

