/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.SourceDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SourceDetailMarshaller {
    private static final MarshallingInfo<String> EVENTSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventSource").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageType").isBinary(false).build();
    private static final MarshallingInfo<String> MAXIMUMEXECUTIONFREQUENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaximumExecutionFrequency").isBinary(false).build();
    private static final SourceDetailMarshaller INSTANCE = new SourceDetailMarshaller();

    private SourceDetailMarshaller() {
    }

    public static SourceDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SourceDetail sourceDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sourceDetail, (String)"sourceDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sourceDetail.eventSourceAsString(), EVENTSOURCE_BINDING);
            protocolMarshaller.marshall((Object)sourceDetail.messageTypeAsString(), MESSAGETYPE_BINDING);
            protocolMarshaller.marshall((Object)sourceDetail.maximumExecutionFrequencyAsString(), MAXIMUMEXECUTIONFREQUENCY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

