/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.Evaluation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EvaluationMarshaller {
    private static final MarshallingInfo<String> COMPLIANCERESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceResourceType").isBinary(false).build();
    private static final MarshallingInfo<String> COMPLIANCERESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceResourceId").isBinary(false).build();
    private static final MarshallingInfo<String> COMPLIANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceType").isBinary(false).build();
    private static final MarshallingInfo<String> ANNOTATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Annotation").isBinary(false).build();
    private static final MarshallingInfo<Instant> ORDERINGTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrderingTimestamp").isBinary(false).build();
    private static final EvaluationMarshaller INSTANCE = new EvaluationMarshaller();

    private EvaluationMarshaller() {
    }

    public static EvaluationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Evaluation evaluation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)evaluation, (String)"evaluation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)evaluation.complianceResourceType(), COMPLIANCERESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)evaluation.complianceResourceId(), COMPLIANCERESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)evaluation.complianceTypeAsString(), COMPLIANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)evaluation.annotation(), ANNOTATION_BINDING);
            protocolMarshaller.marshall((Object)evaluation.orderingTimestamp(), ORDERINGTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

