/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest;
import software.amazon.awssdk.services.config.transform.DeliverConfigSnapshotRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeliverConfigSnapshotRequestMarshaller
implements Marshaller<Request<DeliverConfigSnapshotRequest>, DeliverConfigSnapshotRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("StarlingDoveService.DeliverConfigSnapshot").serviceName("Config Service").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public DeliverConfigSnapshotRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeliverConfigSnapshotRequest> marshall(DeliverConfigSnapshotRequest deliverConfigSnapshotRequest) {
        Validate.paramNotNull((Object)((Object)deliverConfigSnapshotRequest), (String)"deliverConfigSnapshotRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)deliverConfigSnapshotRequest);
            protocolMarshaller.startMarshalling();
            DeliverConfigSnapshotRequestModelMarshaller.getInstance().marshall(deliverConfigSnapshotRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

