/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ComplianceByResource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ComplianceByResourceMarshaller {
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COMPLIANCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Compliance").isBinary(false).build();
    private static final ComplianceByResourceMarshaller INSTANCE = new ComplianceByResourceMarshaller();

    private ComplianceByResourceMarshaller() {
    }

    public static ComplianceByResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ComplianceByResource complianceByResource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)complianceByResource, (String)"complianceByResource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)complianceByResource.resourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)complianceByResource.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)complianceByResource.compliance(), COMPLIANCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

