/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.config.model.ChronologicalOrder;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetResourceConfigHistoryRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, GetResourceConfigHistoryRequest> {
    private final String resourceType;
    private final String resourceId;
    private final Instant laterTime;
    private final Instant earlierTime;
    private final String chronologicalOrder;
    private final Integer limit;
    private final String nextToken;

    private GetResourceConfigHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.laterTime = builder.laterTime;
        this.earlierTime = builder.earlierTime;
        this.chronologicalOrder = builder.chronologicalOrder;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public Instant laterTime() {
        return this.laterTime;
    }

    public Instant earlierTime() {
        return this.earlierTime;
    }

    public ChronologicalOrder chronologicalOrder() {
        return ChronologicalOrder.fromValue(this.chronologicalOrder);
    }

    public String chronologicalOrderAsString() {
        return this.chronologicalOrder;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.laterTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.earlierTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.chronologicalOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceConfigHistoryRequest)) {
            return false;
        }
        GetResourceConfigHistoryRequest other = (GetResourceConfigHistoryRequest)((Object)obj);
        return Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.laterTime(), other.laterTime()) && Objects.equals(this.earlierTime(), other.earlierTime()) && Objects.equals(this.chronologicalOrderAsString(), other.chronologicalOrderAsString()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetResourceConfigHistoryRequest").add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceId", (Object)this.resourceId()).add("LaterTime", (Object)this.laterTime()).add("EarlierTime", (Object)this.earlierTime()).add("ChronologicalOrder", (Object)this.chronologicalOrderAsString()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.of(clazz.cast(this.resourceTypeAsString()));
            }
            case "resourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
            case "laterTime": {
                return Optional.of(clazz.cast(this.laterTime()));
            }
            case "earlierTime": {
                return Optional.of(clazz.cast(this.earlierTime()));
            }
            case "chronologicalOrder": {
                return Optional.of(clazz.cast(this.chronologicalOrderAsString()));
            }
            case "limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String resourceType;
        private String resourceId;
        private Instant laterTime;
        private Instant earlierTime;
        private String chronologicalOrder;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceConfigHistoryRequest model) {
            super(model);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.laterTime(model.laterTime);
            this.earlierTime(model.earlierTime);
            this.chronologicalOrder(model.chronologicalOrder);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Instant getLaterTime() {
            return this.laterTime;
        }

        @Override
        public final Builder laterTime(Instant laterTime) {
            this.laterTime = laterTime;
            return this;
        }

        public final void setLaterTime(Instant laterTime) {
            this.laterTime = laterTime;
        }

        public final Instant getEarlierTime() {
            return this.earlierTime;
        }

        @Override
        public final Builder earlierTime(Instant earlierTime) {
            this.earlierTime = earlierTime;
            return this;
        }

        public final void setEarlierTime(Instant earlierTime) {
            this.earlierTime = earlierTime;
        }

        public final String getChronologicalOrder() {
            return this.chronologicalOrder;
        }

        @Override
        public final Builder chronologicalOrder(String chronologicalOrder) {
            this.chronologicalOrder = chronologicalOrder;
            return this;
        }

        @Override
        public final Builder chronologicalOrder(ChronologicalOrder chronologicalOrder) {
            this.chronologicalOrder(chronologicalOrder.toString());
            return this;
        }

        public final void setChronologicalOrder(String chronologicalOrder) {
            this.chronologicalOrder = chronologicalOrder;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetResourceConfigHistoryRequest build() {
            return new GetResourceConfigHistoryRequest(this);
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    CopyableBuilder<Builder, GetResourceConfigHistoryRequest> {
        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceId(String var1);

        public Builder laterTime(Instant var1);

        public Builder earlierTime(Instant var1);

        public Builder chronologicalOrder(String var1);

        public Builder chronologicalOrder(ChronologicalOrder var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

