/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ConfigSnapshotDeliveryProperties;
import software.amazon.awssdk.services.config.transform.DeliveryChannelMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeliveryChannel
implements StructuredPojo,
ToCopyableBuilder<Builder, DeliveryChannel> {
    private final String name;
    private final String s3BucketName;
    private final String s3KeyPrefix;
    private final String snsTopicARN;
    private final ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties;

    private DeliveryChannel(BuilderImpl builder) {
        this.name = builder.name;
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.snsTopicARN = builder.snsTopicARN;
        this.configSnapshotDeliveryProperties = builder.configSnapshotDeliveryProperties;
    }

    public String name() {
        return this.name;
    }

    public String s3BucketName() {
        return this.s3BucketName;
    }

    public String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public String snsTopicARN() {
        return this.snsTopicARN;
    }

    public ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties() {
        return this.configSnapshotDeliveryProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.s3BucketName() == null ? 0 : this.s3BucketName().hashCode());
        hashCode = 31 * hashCode + (this.s3KeyPrefix() == null ? 0 : this.s3KeyPrefix().hashCode());
        hashCode = 31 * hashCode + (this.snsTopicARN() == null ? 0 : this.snsTopicARN().hashCode());
        hashCode = 31 * hashCode + (this.configSnapshotDeliveryProperties() == null ? 0 : this.configSnapshotDeliveryProperties().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryChannel)) {
            return false;
        }
        DeliveryChannel other = (DeliveryChannel)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.s3BucketName() == null ^ this.s3BucketName() == null) {
            return false;
        }
        if (other.s3BucketName() != null && !other.s3BucketName().equals(this.s3BucketName())) {
            return false;
        }
        if (other.s3KeyPrefix() == null ^ this.s3KeyPrefix() == null) {
            return false;
        }
        if (other.s3KeyPrefix() != null && !other.s3KeyPrefix().equals(this.s3KeyPrefix())) {
            return false;
        }
        if (other.snsTopicARN() == null ^ this.snsTopicARN() == null) {
            return false;
        }
        if (other.snsTopicARN() != null && !other.snsTopicARN().equals(this.snsTopicARN())) {
            return false;
        }
        if (other.configSnapshotDeliveryProperties() == null ^ this.configSnapshotDeliveryProperties() == null) {
            return false;
        }
        return other.configSnapshotDeliveryProperties() == null || other.configSnapshotDeliveryProperties().equals(this.configSnapshotDeliveryProperties());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.s3BucketName() != null) {
            sb.append("S3BucketName: ").append(this.s3BucketName()).append(",");
        }
        if (this.s3KeyPrefix() != null) {
            sb.append("S3KeyPrefix: ").append(this.s3KeyPrefix()).append(",");
        }
        if (this.snsTopicARN() != null) {
            sb.append("SnsTopicARN: ").append(this.snsTopicARN()).append(",");
        }
        if (this.configSnapshotDeliveryProperties() != null) {
            sb.append("ConfigSnapshotDeliveryProperties: ").append(this.configSnapshotDeliveryProperties()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeliveryChannelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String s3BucketName;
        private String s3KeyPrefix;
        private String snsTopicARN;
        private ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryChannel model) {
            this.setName(model.name);
            this.setS3BucketName(model.s3BucketName);
            this.setS3KeyPrefix(model.s3KeyPrefix);
            this.setSnsTopicARN(model.snsTopicARN);
            this.setConfigSnapshotDeliveryProperties(model.configSnapshotDeliveryProperties);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final String getSnsTopicARN() {
            return this.snsTopicARN;
        }

        @Override
        public final Builder snsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
            return this;
        }

        public final void setSnsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
        }

        public final ConfigSnapshotDeliveryProperties getConfigSnapshotDeliveryProperties() {
            return this.configSnapshotDeliveryProperties;
        }

        @Override
        public final Builder configSnapshotDeliveryProperties(ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties) {
            this.configSnapshotDeliveryProperties = configSnapshotDeliveryProperties;
            return this;
        }

        public final void setConfigSnapshotDeliveryProperties(ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties) {
            this.configSnapshotDeliveryProperties = configSnapshotDeliveryProperties;
        }

        public DeliveryChannel build() {
            return new DeliveryChannel(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeliveryChannel> {
        public Builder name(String var1);

        public Builder s3BucketName(String var1);

        public Builder s3KeyPrefix(String var1);

        public Builder snsTopicARN(String var1);

        public Builder configSnapshotDeliveryProperties(ConfigSnapshotDeliveryProperties var1);
    }
}

