/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.ComputeOptimizerAutomationAsyncClient;
import software.amazon.awssdk.services.computeoptimizerautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationRule;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationRulesRequest;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationRulesResponse;

public class ListAutomationRulesPublisher
implements SdkPublisher<ListAutomationRulesResponse> {
    private final ComputeOptimizerAutomationAsyncClient client;
    private final ListAutomationRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAutomationRulesPublisher(ComputeOptimizerAutomationAsyncClient client, ListAutomationRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAutomationRulesPublisher(ComputeOptimizerAutomationAsyncClient client, ListAutomationRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAutomationRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAutomationRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AutomationRule> automationRules() {
        Function<ListAutomationRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.automationRules() != null) {
                return response.automationRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAutomationRulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAutomationRulesResponseFetcher
    implements AsyncPageFetcher<ListAutomationRulesResponse> {
        private ListAutomationRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomationRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAutomationRulesResponse> nextPage(ListAutomationRulesResponse previousPage) {
            if (previousPage == null) {
                return ListAutomationRulesPublisher.this.client.listAutomationRules(ListAutomationRulesPublisher.this.firstRequest);
            }
            return ListAutomationRulesPublisher.this.client.listAutomationRules((ListAutomationRulesRequest)((Object)ListAutomationRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

