/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the scope of a recommendation preference.
 * </p>
 * <p>
 * Recommendation preferences can be created at the organization level (for management accounts of an organization
 * only), account level, and resource level. For more information, see <a
 * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating
 * enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
 * </p>
 * <note>
 * <p>
 * You cannot create recommendation preferences for Amazon EC2 Auto Scaling groups at the organization and account
 * levels. You can create recommendation preferences for Amazon EC2 Auto Scaling groups only at the resource level by
 * specifying a scope name of <code>ResourceArn</code> and a scope value of the Amazon EC2 Auto Scaling group Amazon
 * Resource Name (ARN). This will configure the preference for all instances that are part of the specified Amazon EC2
 * Auto Scaling group. You also cannot create recommendation preferences at the resource level for instances that are
 * part of an Amazon EC2 Auto Scaling group. You can create recommendation preferences at the resource level only for
 * standalone instances.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Scope implements SdkPojo, Serializable, ToCopyableBuilder<Scope.Builder, Scope> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Scope::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(Scope::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String value;

    private Scope(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the scope.
     * </p>
     * <p>
     * The following scopes are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Organization</code> - Specifies that the recommendation preference applies at the organization level, for
     * all member accounts of an organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AccountId</code> - Specifies that the recommendation preference applies at the account level, for all
     * resources of a given resource type in an account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceArn</code> - Specifies that the recommendation preference applies at the individual resource level.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ScopeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the scope.</p>
     *         <p>
     *         The following scopes are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Organization</code> - Specifies that the recommendation preference applies at the organization
     *         level, for all member accounts of an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AccountId</code> - Specifies that the recommendation preference applies at the account level, for
     *         all resources of a given resource type in an account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceArn</code> - Specifies that the recommendation preference applies at the individual
     *         resource level.
     *         </p>
     *         </li>
     * @see ScopeName
     */
    public final ScopeName name() {
        return ScopeName.fromValue(name);
    }

    /**
     * <p>
     * The name of the scope.
     * </p>
     * <p>
     * The following scopes are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Organization</code> - Specifies that the recommendation preference applies at the organization level, for
     * all member accounts of an organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AccountId</code> - Specifies that the recommendation preference applies at the account level, for all
     * resources of a given resource type in an account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceArn</code> - Specifies that the recommendation preference applies at the individual resource level.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ScopeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the scope.</p>
     *         <p>
     *         The following scopes are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Organization</code> - Specifies that the recommendation preference applies at the organization
     *         level, for all member accounts of an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AccountId</code> - Specifies that the recommendation preference applies at the account level, for
     *         all resources of a given resource type in an account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceArn</code> - Specifies that the recommendation preference applies at the individual
     *         resource level.
     *         </p>
     *         </li>
     * @see ScopeName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The value of the scope.
     * </p>
     * <p>
     * If you specified the <code>name</code> of the scope as:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Organization</code> - The <code>value</code> must be <code>ALL_ACCOUNTS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AccountId</code> - The <code>value</code> must be a 12-digit Amazon Web Services account ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceArn</code> - The <code>value</code> must be the Amazon Resource Name (ARN) of an EC2 instance or an
     * Amazon EC2 Auto Scaling group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Only EC2 instance and Amazon EC2 Auto Scaling group ARNs are currently supported.
     * </p>
     * 
     * @return The value of the scope.</p>
     *         <p>
     *         If you specified the <code>name</code> of the scope as:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Organization</code> - The <code>value</code> must be <code>ALL_ACCOUNTS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AccountId</code> - The <code>value</code> must be a 12-digit Amazon Web Services account ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceArn</code> - The <code>value</code> must be the Amazon Resource Name (ARN) of an EC2
     *         instance or an Amazon EC2 Auto Scaling group.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Only EC2 instance and Amazon EC2 Auto Scaling group ARNs are currently supported.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scope)) {
            return false;
        }
        Scope other = (Scope) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Scope").add("Name", nameAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Scope, T> g) {
        return obj -> g.apply((Scope) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Scope> {
        /**
         * <p>
         * The name of the scope.
         * </p>
         * <p>
         * The following scopes are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Organization</code> - Specifies that the recommendation preference applies at the organization level,
         * for all member accounts of an organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccountId</code> - Specifies that the recommendation preference applies at the account level, for all
         * resources of a given resource type in an account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ResourceArn</code> - Specifies that the recommendation preference applies at the individual resource
         * level.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The name of the scope.</p>
         *        <p>
         *        The following scopes are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Organization</code> - Specifies that the recommendation preference applies at the organization
         *        level, for all member accounts of an organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccountId</code> - Specifies that the recommendation preference applies at the account level,
         *        for all resources of a given resource type in an account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceArn</code> - Specifies that the recommendation preference applies at the individual
         *        resource level.
         *        </p>
         *        </li>
         * @see ScopeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScopeName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the scope.
         * </p>
         * <p>
         * The following scopes are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Organization</code> - Specifies that the recommendation preference applies at the organization level,
         * for all member accounts of an organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccountId</code> - Specifies that the recommendation preference applies at the account level, for all
         * resources of a given resource type in an account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ResourceArn</code> - Specifies that the recommendation preference applies at the individual resource
         * level.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The name of the scope.</p>
         *        <p>
         *        The following scopes are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Organization</code> - Specifies that the recommendation preference applies at the organization
         *        level, for all member accounts of an organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccountId</code> - Specifies that the recommendation preference applies at the account level,
         *        for all resources of a given resource type in an account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceArn</code> - Specifies that the recommendation preference applies at the individual
         *        resource level.
         *        </p>
         *        </li>
         * @see ScopeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScopeName
         */
        Builder name(ScopeName name);

        /**
         * <p>
         * The value of the scope.
         * </p>
         * <p>
         * If you specified the <code>name</code> of the scope as:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Organization</code> - The <code>value</code> must be <code>ALL_ACCOUNTS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccountId</code> - The <code>value</code> must be a 12-digit Amazon Web Services account ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ResourceArn</code> - The <code>value</code> must be the Amazon Resource Name (ARN) of an EC2 instance
         * or an Amazon EC2 Auto Scaling group.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Only EC2 instance and Amazon EC2 Auto Scaling group ARNs are currently supported.
         * </p>
         * 
         * @param value
         *        The value of the scope.</p>
         *        <p>
         *        If you specified the <code>name</code> of the scope as:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Organization</code> - The <code>value</code> must be <code>ALL_ACCOUNTS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccountId</code> - The <code>value</code> must be a 12-digit Amazon Web Services account ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceArn</code> - The <code>value</code> must be the Amazon Resource Name (ARN) of an EC2
         *        instance or an Amazon EC2 Auto Scaling group.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Only EC2 instance and Amazon EC2 Auto Scaling group ARNs are currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Scope model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ScopeName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public Scope build() {
            return new Scope(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
