/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the savings opportunity for DB instance recommendations after applying Savings Plans discounts.
 * </p>
 * <p>
 * Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can achieve
 * this by implementing a given Compute Optimizer recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RDSInstanceSavingsOpportunityAfterDiscounts implements SdkPojo, Serializable,
        ToCopyableBuilder<RDSInstanceSavingsOpportunityAfterDiscounts.Builder, RDSInstanceSavingsOpportunityAfterDiscounts> {
    private static final SdkField<Double> SAVINGS_OPPORTUNITY_PERCENTAGE_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("savingsOpportunityPercentage")
            .getter(getter(RDSInstanceSavingsOpportunityAfterDiscounts::savingsOpportunityPercentage))
            .setter(setter(Builder::savingsOpportunityPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunityPercentage")
                    .build()).build();

    private static final SdkField<RDSInstanceEstimatedMonthlySavings> ESTIMATED_MONTHLY_SAVINGS_FIELD = SdkField
            .<RDSInstanceEstimatedMonthlySavings> builder(MarshallingType.SDK_POJO).memberName("estimatedMonthlySavings")
            .getter(getter(RDSInstanceSavingsOpportunityAfterDiscounts::estimatedMonthlySavings))
            .setter(setter(Builder::estimatedMonthlySavings)).constructor(RDSInstanceEstimatedMonthlySavings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlySavings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SAVINGS_OPPORTUNITY_PERCENTAGE_FIELD, ESTIMATED_MONTHLY_SAVINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double savingsOpportunityPercentage;

    private final RDSInstanceEstimatedMonthlySavings estimatedMonthlySavings;

    private RDSInstanceSavingsOpportunityAfterDiscounts(BuilderImpl builder) {
        this.savingsOpportunityPercentage = builder.savingsOpportunityPercentage;
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
    }

    /**
     * <p>
     * The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer’s DB
     * instance recommendations. This includes any applicable Savings Plans discounts.
     * </p>
     * 
     * @return The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer’s DB
     *         instance recommendations. This includes any applicable Savings Plans discounts.
     */
    public final Double savingsOpportunityPercentage() {
        return savingsOpportunityPercentage;
    }

    /**
     * <p>
     * The estimated monthly savings possible by adopting Compute Optimizer’s DB instance recommendations. This includes
     * any applicable Savings Plans discounts.
     * </p>
     * 
     * @return The estimated monthly savings possible by adopting Compute Optimizer’s DB instance recommendations. This
     *         includes any applicable Savings Plans discounts.
     */
    public final RDSInstanceEstimatedMonthlySavings estimatedMonthlySavings() {
        return estimatedMonthlySavings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(savingsOpportunityPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlySavings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSInstanceSavingsOpportunityAfterDiscounts)) {
            return false;
        }
        RDSInstanceSavingsOpportunityAfterDiscounts other = (RDSInstanceSavingsOpportunityAfterDiscounts) obj;
        return Objects.equals(savingsOpportunityPercentage(), other.savingsOpportunityPercentage())
                && Objects.equals(estimatedMonthlySavings(), other.estimatedMonthlySavings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RDSInstanceSavingsOpportunityAfterDiscounts")
                .add("SavingsOpportunityPercentage", savingsOpportunityPercentage())
                .add("EstimatedMonthlySavings", estimatedMonthlySavings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "savingsOpportunityPercentage":
            return Optional.ofNullable(clazz.cast(savingsOpportunityPercentage()));
        case "estimatedMonthlySavings":
            return Optional.ofNullable(clazz.cast(estimatedMonthlySavings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("savingsOpportunityPercentage", SAVINGS_OPPORTUNITY_PERCENTAGE_FIELD);
        map.put("estimatedMonthlySavings", ESTIMATED_MONTHLY_SAVINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RDSInstanceSavingsOpportunityAfterDiscounts, T> g) {
        return obj -> g.apply((RDSInstanceSavingsOpportunityAfterDiscounts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RDSInstanceSavingsOpportunityAfterDiscounts> {
        /**
         * <p>
         * The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer’s DB
         * instance recommendations. This includes any applicable Savings Plans discounts.
         * </p>
         * 
         * @param savingsOpportunityPercentage
         *        The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer’s
         *        DB instance recommendations. This includes any applicable Savings Plans discounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsOpportunityPercentage(Double savingsOpportunityPercentage);

        /**
         * <p>
         * The estimated monthly savings possible by adopting Compute Optimizer’s DB instance recommendations. This
         * includes any applicable Savings Plans discounts.
         * </p>
         * 
         * @param estimatedMonthlySavings
         *        The estimated monthly savings possible by adopting Compute Optimizer’s DB instance recommendations.
         *        This includes any applicable Savings Plans discounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlySavings(RDSInstanceEstimatedMonthlySavings estimatedMonthlySavings);

        /**
         * <p>
         * The estimated monthly savings possible by adopting Compute Optimizer’s DB instance recommendations. This
         * includes any applicable Savings Plans discounts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RDSInstanceEstimatedMonthlySavings.Builder} avoiding the need to create one manually via
         * {@link RDSInstanceEstimatedMonthlySavings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RDSInstanceEstimatedMonthlySavings.Builder#build()} is called
         * immediately and its result is passed to {@link #estimatedMonthlySavings(RDSInstanceEstimatedMonthlySavings)}.
         * 
         * @param estimatedMonthlySavings
         *        a consumer that will call methods on {@link RDSInstanceEstimatedMonthlySavings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #estimatedMonthlySavings(RDSInstanceEstimatedMonthlySavings)
         */
        default Builder estimatedMonthlySavings(Consumer<RDSInstanceEstimatedMonthlySavings.Builder> estimatedMonthlySavings) {
            return estimatedMonthlySavings(RDSInstanceEstimatedMonthlySavings.builder().applyMutation(estimatedMonthlySavings)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Double savingsOpportunityPercentage;

        private RDSInstanceEstimatedMonthlySavings estimatedMonthlySavings;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSInstanceSavingsOpportunityAfterDiscounts model) {
            savingsOpportunityPercentage(model.savingsOpportunityPercentage);
            estimatedMonthlySavings(model.estimatedMonthlySavings);
        }

        public final Double getSavingsOpportunityPercentage() {
            return savingsOpportunityPercentage;
        }

        public final void setSavingsOpportunityPercentage(Double savingsOpportunityPercentage) {
            this.savingsOpportunityPercentage = savingsOpportunityPercentage;
        }

        @Override
        public final Builder savingsOpportunityPercentage(Double savingsOpportunityPercentage) {
            this.savingsOpportunityPercentage = savingsOpportunityPercentage;
            return this;
        }

        public final RDSInstanceEstimatedMonthlySavings.Builder getEstimatedMonthlySavings() {
            return estimatedMonthlySavings != null ? estimatedMonthlySavings.toBuilder() : null;
        }

        public final void setEstimatedMonthlySavings(RDSInstanceEstimatedMonthlySavings.BuilderImpl estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings != null ? estimatedMonthlySavings.build() : null;
        }

        @Override
        public final Builder estimatedMonthlySavings(RDSInstanceEstimatedMonthlySavings estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        @Override
        public RDSInstanceSavingsOpportunityAfterDiscounts build() {
            return new RDSInstanceSavingsOpportunityAfterDiscounts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
