/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum RDSDBMetricName {
    CPU("CPU"),

    MEMORY("Memory"),

    EBS_VOLUME_STORAGE_SPACE_UTILIZATION("EBSVolumeStorageSpaceUtilization"),

    NETWORK_RECEIVE_THROUGHPUT("NetworkReceiveThroughput"),

    NETWORK_TRANSMIT_THROUGHPUT("NetworkTransmitThroughput"),

    EBS_VOLUME_READ_IOPS("EBSVolumeReadIOPS"),

    EBS_VOLUME_WRITE_IOPS("EBSVolumeWriteIOPS"),

    EBS_VOLUME_READ_THROUGHPUT("EBSVolumeReadThroughput"),

    EBS_VOLUME_WRITE_THROUGHPUT("EBSVolumeWriteThroughput"),

    DATABASE_CONNECTIONS("DatabaseConnections"),

    STORAGE_NETWORK_RECEIVE_THROUGHPUT("StorageNetworkReceiveThroughput"),

    STORAGE_NETWORK_TRANSMIT_THROUGHPUT("StorageNetworkTransmitThroughput"),

    AURORA_MEMORY_HEALTH_STATE("AuroraMemoryHealthState"),

    AURORA_MEMORY_NUM_DECLINED_SQL("AuroraMemoryNumDeclinedSql"),

    AURORA_MEMORY_NUM_KILL_CONN_TOTAL("AuroraMemoryNumKillConnTotal"),

    AURORA_MEMORY_NUM_KILL_QUERY_TOTAL("AuroraMemoryNumKillQueryTotal"),

    READ_IOPS_EPHEMERAL_STORAGE("ReadIOPSEphemeralStorage"),

    WRITE_IOPS_EPHEMERAL_STORAGE("WriteIOPSEphemeralStorage"),

    VOLUME_READ_IO_PS("VolumeReadIOPs"),

    VOLUME_BYTES_USED("VolumeBytesUsed"),

    VOLUME_WRITE_IO_PS("VolumeWriteIOPs"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RDSDBMetricName> VALUE_MAP = EnumUtils.uniqueIndex(RDSDBMetricName.class,
            RDSDBMetricName::toString);

    private final String value;

    private RDSDBMetricName(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return RDSDBMetricName corresponding to the value
     */
    public static RDSDBMetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link RDSDBMetricName}s
     */
    public static Set<RDSDBMetricName> knownValues() {
        Set<RDSDBMetricName> knownValues = EnumSet.allOf(RDSDBMetricName.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
