/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the recommendation options for licenses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LicenseRecommendationOption implements SdkPojo, Serializable,
        ToCopyableBuilder<LicenseRecommendationOption.Builder, LicenseRecommendationOption> {
    private static final SdkField<Integer> RANK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("rank")
            .getter(getter(LicenseRecommendationOption::rank)).setter(setter(Builder::rank))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operatingSystem").getter(getter(LicenseRecommendationOption::operatingSystem))
            .setter(setter(Builder::operatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operatingSystem").build()).build();

    private static final SdkField<String> LICENSE_EDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseEdition").getter(getter(LicenseRecommendationOption::licenseEditionAsString))
            .setter(setter(Builder::licenseEdition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseEdition").build()).build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseModel").getter(getter(LicenseRecommendationOption::licenseModelAsString))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseModel").build()).build();

    private static final SdkField<SavingsOpportunity> SAVINGS_OPPORTUNITY_FIELD = SdkField
            .<SavingsOpportunity> builder(MarshallingType.SDK_POJO).memberName("savingsOpportunity")
            .getter(getter(LicenseRecommendationOption::savingsOpportunity)).setter(setter(Builder::savingsOpportunity))
            .constructor(SavingsOpportunity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunity").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RANK_FIELD,
            OPERATING_SYSTEM_FIELD, LICENSE_EDITION_FIELD, LICENSE_MODEL_FIELD, SAVINGS_OPPORTUNITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer rank;

    private final String operatingSystem;

    private final String licenseEdition;

    private final String licenseModel;

    private final SavingsOpportunity savingsOpportunity;

    private LicenseRecommendationOption(BuilderImpl builder) {
        this.rank = builder.rank;
        this.operatingSystem = builder.operatingSystem;
        this.licenseEdition = builder.licenseEdition;
        this.licenseModel = builder.licenseModel;
        this.savingsOpportunity = builder.savingsOpportunity;
    }

    /**
     * <p>
     * The rank of the license recommendation option.
     * </p>
     * <p>
     * The top recommendation option is ranked as <code>1</code>.
     * </p>
     * 
     * @return The rank of the license recommendation option. </p>
     *         <p>
     *         The top recommendation option is ranked as <code>1</code>.
     */
    public final Integer rank() {
        return rank;
    }

    /**
     * <p>
     * The operating system of a license recommendation option.
     * </p>
     * 
     * @return The operating system of a license recommendation option.
     */
    public final String operatingSystem() {
        return operatingSystem;
    }

    /**
     * <p>
     * The recommended edition of the license for the application that runs on the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseEdition}
     * will return {@link LicenseEdition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #licenseEditionAsString}.
     * </p>
     * 
     * @return The recommended edition of the license for the application that runs on the instance.
     * @see LicenseEdition
     */
    public final LicenseEdition licenseEdition() {
        return LicenseEdition.fromValue(licenseEdition);
    }

    /**
     * <p>
     * The recommended edition of the license for the application that runs on the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseEdition}
     * will return {@link LicenseEdition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #licenseEditionAsString}.
     * </p>
     * 
     * @return The recommended edition of the license for the application that runs on the instance.
     * @see LicenseEdition
     */
    public final String licenseEditionAsString() {
        return licenseEdition;
    }

    /**
     * <p>
     * The recommended license type associated with the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseModel} will
     * return {@link LicenseModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseModelAsString}.
     * </p>
     * 
     * @return The recommended license type associated with the instance.
     * @see LicenseModel
     */
    public final LicenseModel licenseModel() {
        return LicenseModel.fromValue(licenseModel);
    }

    /**
     * <p>
     * The recommended license type associated with the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseModel} will
     * return {@link LicenseModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseModelAsString}.
     * </p>
     * 
     * @return The recommended license type associated with the instance.
     * @see LicenseModel
     */
    public final String licenseModelAsString() {
        return licenseModel;
    }

    /**
     * Returns the value of the SavingsOpportunity property for this object.
     * 
     * @return The value of the SavingsOpportunity property for this object.
     */
    public final SavingsOpportunity savingsOpportunity() {
        return savingsOpportunity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rank());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystem());
        hashCode = 31 * hashCode + Objects.hashCode(licenseEditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(savingsOpportunity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseRecommendationOption)) {
            return false;
        }
        LicenseRecommendationOption other = (LicenseRecommendationOption) obj;
        return Objects.equals(rank(), other.rank()) && Objects.equals(operatingSystem(), other.operatingSystem())
                && Objects.equals(licenseEditionAsString(), other.licenseEditionAsString())
                && Objects.equals(licenseModelAsString(), other.licenseModelAsString())
                && Objects.equals(savingsOpportunity(), other.savingsOpportunity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LicenseRecommendationOption").add("Rank", rank()).add("OperatingSystem", operatingSystem())
                .add("LicenseEdition", licenseEditionAsString()).add("LicenseModel", licenseModelAsString())
                .add("SavingsOpportunity", savingsOpportunity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rank":
            return Optional.ofNullable(clazz.cast(rank()));
        case "operatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystem()));
        case "licenseEdition":
            return Optional.ofNullable(clazz.cast(licenseEditionAsString()));
        case "licenseModel":
            return Optional.ofNullable(clazz.cast(licenseModelAsString()));
        case "savingsOpportunity":
            return Optional.ofNullable(clazz.cast(savingsOpportunity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("rank", RANK_FIELD);
        map.put("operatingSystem", OPERATING_SYSTEM_FIELD);
        map.put("licenseEdition", LICENSE_EDITION_FIELD);
        map.put("licenseModel", LICENSE_MODEL_FIELD);
        map.put("savingsOpportunity", SAVINGS_OPPORTUNITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LicenseRecommendationOption, T> g) {
        return obj -> g.apply((LicenseRecommendationOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LicenseRecommendationOption> {
        /**
         * <p>
         * The rank of the license recommendation option.
         * </p>
         * <p>
         * The top recommendation option is ranked as <code>1</code>.
         * </p>
         * 
         * @param rank
         *        The rank of the license recommendation option. </p>
         *        <p>
         *        The top recommendation option is ranked as <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rank(Integer rank);

        /**
         * <p>
         * The operating system of a license recommendation option.
         * </p>
         * 
         * @param operatingSystem
         *        The operating system of a license recommendation option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * The recommended edition of the license for the application that runs on the instance.
         * </p>
         * 
         * @param licenseEdition
         *        The recommended edition of the license for the application that runs on the instance.
         * @see LicenseEdition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseEdition
         */
        Builder licenseEdition(String licenseEdition);

        /**
         * <p>
         * The recommended edition of the license for the application that runs on the instance.
         * </p>
         * 
         * @param licenseEdition
         *        The recommended edition of the license for the application that runs on the instance.
         * @see LicenseEdition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseEdition
         */
        Builder licenseEdition(LicenseEdition licenseEdition);

        /**
         * <p>
         * The recommended license type associated with the instance.
         * </p>
         * 
         * @param licenseModel
         *        The recommended license type associated with the instance.
         * @see LicenseModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseModel
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The recommended license type associated with the instance.
         * </p>
         * 
         * @param licenseModel
         *        The recommended license type associated with the instance.
         * @see LicenseModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseModel
         */
        Builder licenseModel(LicenseModel licenseModel);

        /**
         * Sets the value of the SavingsOpportunity property for this object.
         *
         * @param savingsOpportunity
         *        The new value for the SavingsOpportunity property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsOpportunity(SavingsOpportunity savingsOpportunity);

        /**
         * Sets the value of the SavingsOpportunity property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SavingsOpportunity.Builder} avoiding the
         * need to create one manually via {@link SavingsOpportunity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SavingsOpportunity.Builder#build()} is called immediately and its
         * result is passed to {@link #savingsOpportunity(SavingsOpportunity)}.
         * 
         * @param savingsOpportunity
         *        a consumer that will call methods on {@link SavingsOpportunity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsOpportunity(SavingsOpportunity)
         */
        default Builder savingsOpportunity(Consumer<SavingsOpportunity.Builder> savingsOpportunity) {
            return savingsOpportunity(SavingsOpportunity.builder().applyMutation(savingsOpportunity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer rank;

        private String operatingSystem;

        private String licenseEdition;

        private String licenseModel;

        private SavingsOpportunity savingsOpportunity;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseRecommendationOption model) {
            rank(model.rank);
            operatingSystem(model.operatingSystem);
            licenseEdition(model.licenseEdition);
            licenseModel(model.licenseModel);
            savingsOpportunity(model.savingsOpportunity);
        }

        public final Integer getRank() {
            return rank;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final String getOperatingSystem() {
            return operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public final String getLicenseEdition() {
            return licenseEdition;
        }

        public final void setLicenseEdition(String licenseEdition) {
            this.licenseEdition = licenseEdition;
        }

        @Override
        public final Builder licenseEdition(String licenseEdition) {
            this.licenseEdition = licenseEdition;
            return this;
        }

        @Override
        public final Builder licenseEdition(LicenseEdition licenseEdition) {
            this.licenseEdition(licenseEdition == null ? null : licenseEdition.toString());
            return this;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        @Override
        public final Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel(licenseModel == null ? null : licenseModel.toString());
            return this;
        }

        public final SavingsOpportunity.Builder getSavingsOpportunity() {
            return savingsOpportunity != null ? savingsOpportunity.toBuilder() : null;
        }

        public final void setSavingsOpportunity(SavingsOpportunity.BuilderImpl savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity != null ? savingsOpportunity.build() : null;
        }

        @Override
        public final Builder savingsOpportunity(SavingsOpportunity savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity;
            return this;
        }

        @Override
        public LicenseRecommendationOption build() {
            return new LicenseRecommendationOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
