/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the savings estimation mode used for calculating savings opportunity for Amazon EC2 instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceSavingsEstimationMode implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceSavingsEstimationMode.Builder, InstanceSavingsEstimationMode> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(InstanceSavingsEstimationMode::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String source;

    private InstanceSavingsEstimationMode(BuilderImpl builder) {
        this.source = builder.source;
    }

    /**
     * <p>
     * Describes the source for calculating the savings opportunity for Amazon EC2 instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link InstanceSavingsEstimationModeSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #sourceAsString}.
     * </p>
     * 
     * @return Describes the source for calculating the savings opportunity for Amazon EC2 instances.
     * @see InstanceSavingsEstimationModeSource
     */
    public final InstanceSavingsEstimationModeSource source() {
        return InstanceSavingsEstimationModeSource.fromValue(source);
    }

    /**
     * <p>
     * Describes the source for calculating the savings opportunity for Amazon EC2 instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link InstanceSavingsEstimationModeSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #sourceAsString}.
     * </p>
     * 
     * @return Describes the source for calculating the savings opportunity for Amazon EC2 instances.
     * @see InstanceSavingsEstimationModeSource
     */
    public final String sourceAsString() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSavingsEstimationMode)) {
            return false;
        }
        InstanceSavingsEstimationMode other = (InstanceSavingsEstimationMode) obj;
        return Objects.equals(sourceAsString(), other.sourceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceSavingsEstimationMode").add("Source", sourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("source", SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceSavingsEstimationMode, T> g) {
        return obj -> g.apply((InstanceSavingsEstimationMode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceSavingsEstimationMode> {
        /**
         * <p>
         * Describes the source for calculating the savings opportunity for Amazon EC2 instances.
         * </p>
         * 
         * @param source
         *        Describes the source for calculating the savings opportunity for Amazon EC2 instances.
         * @see InstanceSavingsEstimationModeSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceSavingsEstimationModeSource
         */
        Builder source(String source);

        /**
         * <p>
         * Describes the source for calculating the savings opportunity for Amazon EC2 instances.
         * </p>
         * 
         * @param source
         *        Describes the source for calculating the savings opportunity for Amazon EC2 instances.
         * @see InstanceSavingsEstimationModeSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceSavingsEstimationModeSource
         */
        Builder source(InstanceSavingsEstimationModeSource source);
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSavingsEstimationMode model) {
            source(model.source);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(InstanceSavingsEstimationModeSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        @Override
        public InstanceSavingsEstimationMode build() {
            return new InstanceSavingsEstimationMode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
