/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdleRecommendationsResponse extends ComputeOptimizerResponse implements
        ToCopyableBuilder<GetIdleRecommendationsResponse.Builder, GetIdleRecommendationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetIdleRecommendationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<IdleRecommendation>> IDLE_RECOMMENDATIONS_FIELD = SdkField
            .<List<IdleRecommendation>> builder(MarshallingType.LIST)
            .memberName("idleRecommendations")
            .getter(getter(GetIdleRecommendationsResponse::idleRecommendations))
            .setter(setter(Builder::idleRecommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleRecommendations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdleRecommendation> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdleRecommendation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<IdleRecommendationError>> ERRORS_FIELD = SdkField
            .<List<IdleRecommendationError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(GetIdleRecommendationsResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdleRecommendationError> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdleRecommendationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            IDLE_RECOMMENDATIONS_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<IdleRecommendation> idleRecommendations;

    private final List<IdleRecommendationError> errors;

    private GetIdleRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.idleRecommendations = builder.idleRecommendations;
        this.errors = builder.errors;
    }

    /**
     * <p>
     * The token to advance to the next page of idle resource recommendations.
     * </p>
     * 
     * @return The token to advance to the next page of idle resource recommendations.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdleRecommendations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIdleRecommendations() {
        return idleRecommendations != null && !(idleRecommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the idle resource recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdleRecommendations} method.
     * </p>
     * 
     * @return An array of objects that describe the idle resource recommendations.
     */
    public final List<IdleRecommendation> idleRecommendations() {
        return idleRecommendations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe errors of the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return An array of objects that describe errors of the request.
     */
    public final List<IdleRecommendationError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdleRecommendations() ? idleRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdleRecommendationsResponse)) {
            return false;
        }
        GetIdleRecommendationsResponse other = (GetIdleRecommendationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasIdleRecommendations() == other.hasIdleRecommendations()
                && Objects.equals(idleRecommendations(), other.idleRecommendations()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIdleRecommendationsResponse").add("NextToken", nextToken())
                .add("IdleRecommendations", hasIdleRecommendations() ? idleRecommendations() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "idleRecommendations":
            return Optional.ofNullable(clazz.cast(idleRecommendations()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("idleRecommendations", IDLE_RECOMMENDATIONS_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIdleRecommendationsResponse, T> g) {
        return obj -> g.apply((GetIdleRecommendationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComputeOptimizerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIdleRecommendationsResponse> {
        /**
         * <p>
         * The token to advance to the next page of idle resource recommendations.
         * </p>
         * 
         * @param nextToken
         *        The token to advance to the next page of idle resource recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of objects that describe the idle resource recommendations.
         * </p>
         * 
         * @param idleRecommendations
         *        An array of objects that describe the idle resource recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleRecommendations(Collection<IdleRecommendation> idleRecommendations);

        /**
         * <p>
         * An array of objects that describe the idle resource recommendations.
         * </p>
         * 
         * @param idleRecommendations
         *        An array of objects that describe the idle resource recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleRecommendations(IdleRecommendation... idleRecommendations);

        /**
         * <p>
         * An array of objects that describe the idle resource recommendations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendation.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendation.Builder#build()} is called
         * immediately and its result is passed to {@link #idleRecommendations(List<IdleRecommendation>)}.
         * 
         * @param idleRecommendations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #idleRecommendations(java.util.Collection<IdleRecommendation>)
         */
        Builder idleRecommendations(Consumer<IdleRecommendation.Builder>... idleRecommendations);

        /**
         * <p>
         * An array of objects that describe errors of the request.
         * </p>
         * 
         * @param errors
         *        An array of objects that describe errors of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<IdleRecommendationError> errors);

        /**
         * <p>
         * An array of objects that describe errors of the request.
         * </p>
         * 
         * @param errors
         *        An array of objects that describe errors of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(IdleRecommendationError... errors);

        /**
         * <p>
         * An array of objects that describe errors of the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendationError.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendationError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendationError.Builder#build()} is
         * called immediately and its result is passed to {@link #errors(List<IdleRecommendationError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendationError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<IdleRecommendationError>)
         */
        Builder errors(Consumer<IdleRecommendationError.Builder>... errors);
    }

    static final class BuilderImpl extends ComputeOptimizerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<IdleRecommendation> idleRecommendations = DefaultSdkAutoConstructList.getInstance();

        private List<IdleRecommendationError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdleRecommendationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            idleRecommendations(model.idleRecommendations);
            errors(model.errors);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<IdleRecommendation.Builder> getIdleRecommendations() {
            List<IdleRecommendation.Builder> result = IdleRecommendationsCopier.copyToBuilder(this.idleRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdleRecommendations(Collection<IdleRecommendation.BuilderImpl> idleRecommendations) {
            this.idleRecommendations = IdleRecommendationsCopier.copyFromBuilder(idleRecommendations);
        }

        @Override
        public final Builder idleRecommendations(Collection<IdleRecommendation> idleRecommendations) {
            this.idleRecommendations = IdleRecommendationsCopier.copy(idleRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idleRecommendations(IdleRecommendation... idleRecommendations) {
            idleRecommendations(Arrays.asList(idleRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idleRecommendations(Consumer<IdleRecommendation.Builder>... idleRecommendations) {
            idleRecommendations(Stream.of(idleRecommendations).map(c -> IdleRecommendation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<IdleRecommendationError.Builder> getErrors() {
            List<IdleRecommendationError.Builder> result = IdleRecommendationErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<IdleRecommendationError.BuilderImpl> errors) {
            this.errors = IdleRecommendationErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<IdleRecommendationError> errors) {
            this.errors = IdleRecommendationErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(IdleRecommendationError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<IdleRecommendationError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> IdleRecommendationError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetIdleRecommendationsResponse build() {
            return new GetIdleRecommendationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
