/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ExportableIdleField {
    ACCOUNT_ID("AccountId"),

    RESOURCE_ARN("ResourceArn"),

    RESOURCE_ID("ResourceId"),

    RESOURCE_TYPE("ResourceType"),

    LAST_REFRESH_TIMESTAMP("LastRefreshTimestamp"),

    LOOKBACK_PERIOD_IN_DAYS("LookbackPeriodInDays"),

    SAVINGS_OPPORTUNITY("SavingsOpportunity"),

    SAVINGS_OPPORTUNITY_AFTER_DISCOUNT("SavingsOpportunityAfterDiscount"),

    UTILIZATION_METRICS_CPU_MAXIMUM("UtilizationMetricsCpuMaximum"),

    UTILIZATION_METRICS_MEMORY_MAXIMUM("UtilizationMetricsMemoryMaximum"),

    UTILIZATION_METRICS_NETWORK_OUT_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsNetworkOutBytesPerSecondMaximum"),

    UTILIZATION_METRICS_NETWORK_IN_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsNetworkInBytesPerSecondMaximum"),

    UTILIZATION_METRICS_DATABASE_CONNECTIONS_MAXIMUM("UtilizationMetricsDatabaseConnectionsMaximum"),

    UTILIZATION_METRICS_EBS_VOLUME_READ_IOPS_MAXIMUM("UtilizationMetricsEBSVolumeReadIOPSMaximum"),

    UTILIZATION_METRICS_EBS_VOLUME_WRITE_IOPS_MAXIMUM("UtilizationMetricsEBSVolumeWriteIOPSMaximum"),

    UTILIZATION_METRICS_VOLUME_READ_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsVolumeReadOpsPerSecondMaximum"),

    UTILIZATION_METRICS_VOLUME_WRITE_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsVolumeWriteOpsPerSecondMaximum"),

    UTILIZATION_METRICS_ACTIVE_CONNECTION_COUNT_MAXIMUM("UtilizationMetricsActiveConnectionCountMaximum"),

    UTILIZATION_METRICS_PACKETS_IN_FROM_SOURCE_MAXIMUM("UtilizationMetricsPacketsInFromSourceMaximum"),

    UTILIZATION_METRICS_PACKETS_IN_FROM_DESTINATION_MAXIMUM("UtilizationMetricsPacketsInFromDestinationMaximum"),

    FINDING("Finding"),

    FINDING_DESCRIPTION("FindingDescription"),

    TAGS("Tags"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportableIdleField> VALUE_MAP = EnumUtils.uniqueIndex(ExportableIdleField.class,
            ExportableIdleField::toString);

    private final String value;

    private ExportableIdleField(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ExportableIdleField corresponding to the value
     */
    public static ExportableIdleField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ExportableIdleField}s
     */
    public static Set<ExportableIdleField> knownValues() {
        Set<ExportableIdleField> knownValues = EnumSet.allOf(ExportableIdleField.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
