/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportRdsDatabaseRecommendationsResponse extends ComputeOptimizerResponse implements
        ToCopyableBuilder<ExportRdsDatabaseRecommendationsResponse.Builder, ExportRdsDatabaseRecommendationsResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(ExportRdsDatabaseRecommendationsResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<S3Destination> S3_DESTINATION_FIELD = SdkField
            .<S3Destination> builder(MarshallingType.SDK_POJO).memberName("s3Destination")
            .getter(getter(ExportRdsDatabaseRecommendationsResponse::s3Destination)).setter(setter(Builder::s3Destination))
            .constructor(S3Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            S3_DESTINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobId;

    private final S3Destination s3Destination;

    private ExportRdsDatabaseRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.s3Destination = builder.s3Destination;
    }

    /**
     * <p>
     * The identification number of the export job.
     * </p>
     * <p>
     * To view the status of an export job, use the <a>DescribeRecommendationExportJobs</a> action and specify the job
     * ID.
     * </p>
     * 
     * @return The identification number of the export job. </p>
     *         <p>
     *         To view the status of an export job, use the <a>DescribeRecommendationExportJobs</a> action and specify
     *         the job ID.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * Returns the value of the S3Destination property for this object.
     * 
     * @return The value of the S3Destination property for this object.
     */
    public final S3Destination s3Destination() {
        return s3Destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(s3Destination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportRdsDatabaseRecommendationsResponse)) {
            return false;
        }
        ExportRdsDatabaseRecommendationsResponse other = (ExportRdsDatabaseRecommendationsResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(s3Destination(), other.s3Destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportRdsDatabaseRecommendationsResponse").add("JobId", jobId())
                .add("S3Destination", s3Destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "s3Destination":
            return Optional.ofNullable(clazz.cast(s3Destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobId", JOB_ID_FIELD);
        map.put("s3Destination", S3_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportRdsDatabaseRecommendationsResponse, T> g) {
        return obj -> g.apply((ExportRdsDatabaseRecommendationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComputeOptimizerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ExportRdsDatabaseRecommendationsResponse> {
        /**
         * <p>
         * The identification number of the export job.
         * </p>
         * <p>
         * To view the status of an export job, use the <a>DescribeRecommendationExportJobs</a> action and specify the
         * job ID.
         * </p>
         * 
         * @param jobId
         *        The identification number of the export job. </p>
         *        <p>
         *        To view the status of an export job, use the <a>DescribeRecommendationExportJobs</a> action and
         *        specify the job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * Sets the value of the S3Destination property for this object.
         *
         * @param s3Destination
         *        The new value for the S3Destination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Destination(S3Destination s3Destination);

        /**
         * Sets the value of the S3Destination property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3Destination.Builder} avoiding the need
         * to create one manually via {@link S3Destination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Destination.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Destination(S3Destination)}.
         * 
         * @param s3Destination
         *        a consumer that will call methods on {@link S3Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Destination(S3Destination)
         */
        default Builder s3Destination(Consumer<S3Destination.Builder> s3Destination) {
            return s3Destination(S3Destination.builder().applyMutation(s3Destination).build());
        }
    }

    static final class BuilderImpl extends ComputeOptimizerResponse.BuilderImpl implements Builder {
        private String jobId;

        private S3Destination s3Destination;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportRdsDatabaseRecommendationsResponse model) {
            super(model);
            jobId(model.jobId);
            s3Destination(model.s3Destination);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final S3Destination.Builder getS3Destination() {
            return s3Destination != null ? s3Destination.toBuilder() : null;
        }

        public final void setS3Destination(S3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public final Builder s3Destination(S3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        @Override
        public ExportRdsDatabaseRecommendationsResponse build() {
            return new ExportRdsDatabaseRecommendationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
