/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the projected utilization metrics of an Amazon ECS service recommendation option.
 * </p>
 * <p>
 * To determine the performance difference between your current Amazon ECS service and the recommended option, compare
 * the utilization metric data of your service against its projected utilization metric data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ECSServiceProjectedUtilizationMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<ECSServiceProjectedUtilizationMetric.Builder, ECSServiceProjectedUtilizationMetric> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ECSServiceProjectedUtilizationMetric::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATISTIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statistic").getter(getter(ECSServiceProjectedUtilizationMetric::statisticAsString))
            .setter(setter(Builder::statistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistic").build()).build();

    private static final SdkField<Double> LOWER_BOUND_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("lowerBoundValue").getter(getter(ECSServiceProjectedUtilizationMetric::lowerBoundValue))
            .setter(setter(Builder::lowerBoundValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lowerBoundValue").build()).build();

    private static final SdkField<Double> UPPER_BOUND_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("upperBoundValue").getter(getter(ECSServiceProjectedUtilizationMetric::upperBoundValue))
            .setter(setter(Builder::upperBoundValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upperBoundValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATISTIC_FIELD,
            LOWER_BOUND_VALUE_FIELD, UPPER_BOUND_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String statistic;

    private final Double lowerBoundValue;

    private final Double upperBoundValue;

    private ECSServiceProjectedUtilizationMetric(BuilderImpl builder) {
        this.name = builder.name;
        this.statistic = builder.statistic;
        this.lowerBoundValue = builder.lowerBoundValue;
        this.upperBoundValue = builder.upperBoundValue;
    }

    /**
     * <p>
     * The name of the projected utilization metric.
     * </p>
     * <p>
     * The following utilization metrics are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Cpu</code> — The percentage of allocated compute units that are currently in use on the service tasks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Memory</code> — The percentage of memory that's currently in use on the service tasks.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ECSServiceMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the projected utilization metric. </p>
     *         <p>
     *         The following utilization metrics are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Cpu</code> — The percentage of allocated compute units that are currently in use on the service
     *         tasks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Memory</code> — The percentage of memory that's currently in use on the service tasks.
     *         </p>
     *         </li>
     * @see ECSServiceMetricName
     */
    public final ECSServiceMetricName name() {
        return ECSServiceMetricName.fromValue(name);
    }

    /**
     * <p>
     * The name of the projected utilization metric.
     * </p>
     * <p>
     * The following utilization metrics are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Cpu</code> — The percentage of allocated compute units that are currently in use on the service tasks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Memory</code> — The percentage of memory that's currently in use on the service tasks.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ECSServiceMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the projected utilization metric. </p>
     *         <p>
     *         The following utilization metrics are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Cpu</code> — The percentage of allocated compute units that are currently in use on the service
     *         tasks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Memory</code> — The percentage of memory that's currently in use on the service tasks.
     *         </p>
     *         </li>
     * @see ECSServiceMetricName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The statistic of the projected utilization metric.
     * </p>
     * <p>
     * The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the
     * <code>Maximum</code> statistic, which is the highest value observed during the specified period.
     * </p>
     * <p>
     * The Compute Optimizer console displays graphs for some utilization metrics using the <code>Average</code>
     * statistic, which is the value of <code>Sum</code> / <code>SampleCount</code> during the specified period. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
     * recommendations</a> in the <i>Compute Optimizer User Guide</i>. You can also get averaged utilization metric data
     * for your resources using Amazon CloudWatch. For more information, see the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
     * User Guide</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link ECSServiceMetricStatistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic of the projected utilization metric.</p>
     *         <p>
     *         The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only
     *         the <code>Maximum</code> statistic, which is the highest value observed during the specified period.
     *         </p>
     *         <p>
     *         The Compute Optimizer console displays graphs for some utilization metrics using the <code>Average</code>
     *         statistic, which is the value of <code>Sum</code> / <code>SampleCount</code> during the specified period.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing
     *         resource recommendations</a> in the <i>Compute Optimizer User Guide</i>. You can also get averaged
     *         utilization metric data for your resources using Amazon CloudWatch. For more information, see the <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon
     *         CloudWatch User Guide</a>.
     * @see ECSServiceMetricStatistic
     */
    public final ECSServiceMetricStatistic statistic() {
        return ECSServiceMetricStatistic.fromValue(statistic);
    }

    /**
     * <p>
     * The statistic of the projected utilization metric.
     * </p>
     * <p>
     * The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the
     * <code>Maximum</code> statistic, which is the highest value observed during the specified period.
     * </p>
     * <p>
     * The Compute Optimizer console displays graphs for some utilization metrics using the <code>Average</code>
     * statistic, which is the value of <code>Sum</code> / <code>SampleCount</code> during the specified period. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
     * recommendations</a> in the <i>Compute Optimizer User Guide</i>. You can also get averaged utilization metric data
     * for your resources using Amazon CloudWatch. For more information, see the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
     * User Guide</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link ECSServiceMetricStatistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic of the projected utilization metric.</p>
     *         <p>
     *         The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only
     *         the <code>Maximum</code> statistic, which is the highest value observed during the specified period.
     *         </p>
     *         <p>
     *         The Compute Optimizer console displays graphs for some utilization metrics using the <code>Average</code>
     *         statistic, which is the value of <code>Sum</code> / <code>SampleCount</code> during the specified period.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing
     *         resource recommendations</a> in the <i>Compute Optimizer User Guide</i>. You can also get averaged
     *         utilization metric data for your resources using Amazon CloudWatch. For more information, see the <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon
     *         CloudWatch User Guide</a>.
     * @see ECSServiceMetricStatistic
     */
    public final String statisticAsString() {
        return statistic;
    }

    /**
     * <p>
     * The lower bound values for the projected utilization metrics.
     * </p>
     * 
     * @return The lower bound values for the projected utilization metrics.
     */
    public final Double lowerBoundValue() {
        return lowerBoundValue;
    }

    /**
     * <p>
     * The upper bound values for the projected utilization metrics.
     * </p>
     * 
     * @return The upper bound values for the projected utilization metrics.
     */
    public final Double upperBoundValue() {
        return upperBoundValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lowerBoundValue());
        hashCode = 31 * hashCode + Objects.hashCode(upperBoundValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ECSServiceProjectedUtilizationMetric)) {
            return false;
        }
        ECSServiceProjectedUtilizationMetric other = (ECSServiceProjectedUtilizationMetric) obj;
        return Objects.equals(nameAsString(), other.nameAsString())
                && Objects.equals(statisticAsString(), other.statisticAsString())
                && Objects.equals(lowerBoundValue(), other.lowerBoundValue())
                && Objects.equals(upperBoundValue(), other.upperBoundValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ECSServiceProjectedUtilizationMetric").add("Name", nameAsString())
                .add("Statistic", statisticAsString()).add("LowerBoundValue", lowerBoundValue())
                .add("UpperBoundValue", upperBoundValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "statistic":
            return Optional.ofNullable(clazz.cast(statisticAsString()));
        case "lowerBoundValue":
            return Optional.ofNullable(clazz.cast(lowerBoundValue()));
        case "upperBoundValue":
            return Optional.ofNullable(clazz.cast(upperBoundValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("statistic", STATISTIC_FIELD);
        map.put("lowerBoundValue", LOWER_BOUND_VALUE_FIELD);
        map.put("upperBoundValue", UPPER_BOUND_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ECSServiceProjectedUtilizationMetric, T> g) {
        return obj -> g.apply((ECSServiceProjectedUtilizationMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ECSServiceProjectedUtilizationMetric> {
        /**
         * <p>
         * The name of the projected utilization metric.
         * </p>
         * <p>
         * The following utilization metrics are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Cpu</code> — The percentage of allocated compute units that are currently in use on the service tasks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Memory</code> — The percentage of memory that's currently in use on the service tasks.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The name of the projected utilization metric. </p>
         *        <p>
         *        The following utilization metrics are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Cpu</code> — The percentage of allocated compute units that are currently in use on the service
         *        tasks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Memory</code> — The percentage of memory that's currently in use on the service tasks.
         *        </p>
         *        </li>
         * @see ECSServiceMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ECSServiceMetricName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the projected utilization metric.
         * </p>
         * <p>
         * The following utilization metrics are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Cpu</code> — The percentage of allocated compute units that are currently in use on the service tasks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Memory</code> — The percentage of memory that's currently in use on the service tasks.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The name of the projected utilization metric. </p>
         *        <p>
         *        The following utilization metrics are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Cpu</code> — The percentage of allocated compute units that are currently in use on the service
         *        tasks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Memory</code> — The percentage of memory that's currently in use on the service tasks.
         *        </p>
         *        </li>
         * @see ECSServiceMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ECSServiceMetricName
         */
        Builder name(ECSServiceMetricName name);

        /**
         * <p>
         * The statistic of the projected utilization metric.
         * </p>
         * <p>
         * The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the
         * <code>Maximum</code> statistic, which is the highest value observed during the specified period.
         * </p>
         * <p>
         * The Compute Optimizer console displays graphs for some utilization metrics using the <code>Average</code>
         * statistic, which is the value of <code>Sum</code> / <code>SampleCount</code> during the specified period. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
         * recommendations</a> in the <i>Compute Optimizer User Guide</i>. You can also get averaged utilization metric
         * data for your resources using Amazon CloudWatch. For more information, see the <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
         * User Guide</a>.
         * </p>
         * 
         * @param statistic
         *        The statistic of the projected utilization metric.</p>
         *        <p>
         *        The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using
         *        only the <code>Maximum</code> statistic, which is the highest value observed during the specified
         *        period.
         *        </p>
         *        <p>
         *        The Compute Optimizer console displays graphs for some utilization metrics using the
         *        <code>Average</code> statistic, which is the value of <code>Sum</code> / <code>SampleCount</code>
         *        during the specified period. For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing
         *        resource recommendations</a> in the <i>Compute Optimizer User Guide</i>. You can also get averaged
         *        utilization metric data for your resources using Amazon CloudWatch. For more information, see the <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon
         *        CloudWatch User Guide</a>.
         * @see ECSServiceMetricStatistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ECSServiceMetricStatistic
         */
        Builder statistic(String statistic);

        /**
         * <p>
         * The statistic of the projected utilization metric.
         * </p>
         * <p>
         * The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the
         * <code>Maximum</code> statistic, which is the highest value observed during the specified period.
         * </p>
         * <p>
         * The Compute Optimizer console displays graphs for some utilization metrics using the <code>Average</code>
         * statistic, which is the value of <code>Sum</code> / <code>SampleCount</code> during the specified period. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
         * recommendations</a> in the <i>Compute Optimizer User Guide</i>. You can also get averaged utilization metric
         * data for your resources using Amazon CloudWatch. For more information, see the <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
         * User Guide</a>.
         * </p>
         * 
         * @param statistic
         *        The statistic of the projected utilization metric.</p>
         *        <p>
         *        The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using
         *        only the <code>Maximum</code> statistic, which is the highest value observed during the specified
         *        period.
         *        </p>
         *        <p>
         *        The Compute Optimizer console displays graphs for some utilization metrics using the
         *        <code>Average</code> statistic, which is the value of <code>Sum</code> / <code>SampleCount</code>
         *        during the specified period. For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing
         *        resource recommendations</a> in the <i>Compute Optimizer User Guide</i>. You can also get averaged
         *        utilization metric data for your resources using Amazon CloudWatch. For more information, see the <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon
         *        CloudWatch User Guide</a>.
         * @see ECSServiceMetricStatistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ECSServiceMetricStatistic
         */
        Builder statistic(ECSServiceMetricStatistic statistic);

        /**
         * <p>
         * The lower bound values for the projected utilization metrics.
         * </p>
         * 
         * @param lowerBoundValue
         *        The lower bound values for the projected utilization metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowerBoundValue(Double lowerBoundValue);

        /**
         * <p>
         * The upper bound values for the projected utilization metrics.
         * </p>
         * 
         * @param upperBoundValue
         *        The upper bound values for the projected utilization metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upperBoundValue(Double upperBoundValue);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String statistic;

        private Double lowerBoundValue;

        private Double upperBoundValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ECSServiceProjectedUtilizationMetric model) {
            name(model.name);
            statistic(model.statistic);
            lowerBoundValue(model.lowerBoundValue);
            upperBoundValue(model.upperBoundValue);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ECSServiceMetricName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getStatistic() {
            return statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(ECSServiceMetricStatistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final Double getLowerBoundValue() {
            return lowerBoundValue;
        }

        public final void setLowerBoundValue(Double lowerBoundValue) {
            this.lowerBoundValue = lowerBoundValue;
        }

        @Override
        public final Builder lowerBoundValue(Double lowerBoundValue) {
            this.lowerBoundValue = lowerBoundValue;
            return this;
        }

        public final Double getUpperBoundValue() {
            return upperBoundValue;
        }

        public final void setUpperBoundValue(Double upperBoundValue) {
            this.upperBoundValue = upperBoundValue;
        }

        @Override
        public final Builder upperBoundValue(Double upperBoundValue) {
            this.upperBoundValue = upperBoundValue;
            return this;
        }

        @Override
        public ECSServiceProjectedUtilizationMetric build() {
            return new ECSServiceProjectedUtilizationMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
