/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RDSDBMetricName {
    CPU("CPU"),
    MEMORY("Memory"),
    EBS_VOLUME_STORAGE_SPACE_UTILIZATION("EBSVolumeStorageSpaceUtilization"),
    NETWORK_RECEIVE_THROUGHPUT("NetworkReceiveThroughput"),
    NETWORK_TRANSMIT_THROUGHPUT("NetworkTransmitThroughput"),
    EBS_VOLUME_READ_IOPS("EBSVolumeReadIOPS"),
    EBS_VOLUME_WRITE_IOPS("EBSVolumeWriteIOPS"),
    EBS_VOLUME_READ_THROUGHPUT("EBSVolumeReadThroughput"),
    EBS_VOLUME_WRITE_THROUGHPUT("EBSVolumeWriteThroughput"),
    DATABASE_CONNECTIONS("DatabaseConnections"),
    STORAGE_NETWORK_RECEIVE_THROUGHPUT("StorageNetworkReceiveThroughput"),
    STORAGE_NETWORK_TRANSMIT_THROUGHPUT("StorageNetworkTransmitThroughput"),
    AURORA_MEMORY_HEALTH_STATE("AuroraMemoryHealthState"),
    AURORA_MEMORY_NUM_DECLINED_SQL("AuroraMemoryNumDeclinedSql"),
    AURORA_MEMORY_NUM_KILL_CONN_TOTAL("AuroraMemoryNumKillConnTotal"),
    AURORA_MEMORY_NUM_KILL_QUERY_TOTAL("AuroraMemoryNumKillQueryTotal"),
    READ_IOPS_EPHEMERAL_STORAGE("ReadIOPSEphemeralStorage"),
    WRITE_IOPS_EPHEMERAL_STORAGE("WriteIOPSEphemeralStorage"),
    VOLUME_READ_IO_PS("VolumeReadIOPs"),
    VOLUME_BYTES_USED("VolumeBytesUsed"),
    VOLUME_WRITE_IO_PS("VolumeWriteIOPs"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RDSDBMetricName> VALUE_MAP;
    private final String value;

    private RDSDBMetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RDSDBMetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RDSDBMetricName> knownValues() {
        EnumSet<RDSDBMetricName> knownValues = EnumSet.allOf(RDSDBMetricName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RDSDBMetricName.class, RDSDBMetricName::toString);
    }
}

