/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.EBSSavingsOpportunityAfterDiscounts;
import software.amazon.awssdk.services.computeoptimizer.model.SavingsOpportunity;
import software.amazon.awssdk.services.computeoptimizer.model.VolumeConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeRecommendationOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeRecommendationOption> {
    private static final SdkField<VolumeConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(VolumeRecommendationOption.getter(VolumeRecommendationOption::configuration)).setter(VolumeRecommendationOption.setter(Builder::configuration)).constructor(VolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<Double> PERFORMANCE_RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("performanceRisk").getter(VolumeRecommendationOption.getter(VolumeRecommendationOption::performanceRisk)).setter(VolumeRecommendationOption.setter(Builder::performanceRisk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performanceRisk").build()}).build();
    private static final SdkField<Integer> RANK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("rank").getter(VolumeRecommendationOption.getter(VolumeRecommendationOption::rank)).setter(VolumeRecommendationOption.setter(Builder::rank)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()}).build();
    private static final SdkField<SavingsOpportunity> SAVINGS_OPPORTUNITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsOpportunity").getter(VolumeRecommendationOption.getter(VolumeRecommendationOption::savingsOpportunity)).setter(VolumeRecommendationOption.setter(Builder::savingsOpportunity)).constructor(SavingsOpportunity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunity").build()}).build();
    private static final SdkField<EBSSavingsOpportunityAfterDiscounts> SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsOpportunityAfterDiscounts").getter(VolumeRecommendationOption.getter(VolumeRecommendationOption::savingsOpportunityAfterDiscounts)).setter(VolumeRecommendationOption.setter(Builder::savingsOpportunityAfterDiscounts)).constructor(EBSSavingsOpportunityAfterDiscounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunityAfterDiscounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, PERFORMANCE_RISK_FIELD, RANK_FIELD, SAVINGS_OPPORTUNITY_FIELD, SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("configuration", CONFIGURATION_FIELD);
            this.put("performanceRisk", PERFORMANCE_RISK_FIELD);
            this.put("rank", RANK_FIELD);
            this.put("savingsOpportunity", SAVINGS_OPPORTUNITY_FIELD);
            this.put("savingsOpportunityAfterDiscounts", SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final VolumeConfiguration configuration;
    private final Double performanceRisk;
    private final Integer rank;
    private final SavingsOpportunity savingsOpportunity;
    private final EBSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;

    private VolumeRecommendationOption(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.performanceRisk = builder.performanceRisk;
        this.rank = builder.rank;
        this.savingsOpportunity = builder.savingsOpportunity;
        this.savingsOpportunityAfterDiscounts = builder.savingsOpportunityAfterDiscounts;
    }

    public final VolumeConfiguration configuration() {
        return this.configuration;
    }

    public final Double performanceRisk() {
        return this.performanceRisk;
    }

    public final Integer rank() {
        return this.rank;
    }

    public final SavingsOpportunity savingsOpportunity() {
        return this.savingsOpportunity;
    }

    public final EBSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts() {
        return this.savingsOpportunityAfterDiscounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceRisk());
        hashCode = 31 * hashCode + Objects.hashCode(this.rank());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunity());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunityAfterDiscounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeRecommendationOption)) {
            return false;
        }
        VolumeRecommendationOption other = (VolumeRecommendationOption)obj;
        return Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.performanceRisk(), other.performanceRisk()) && Objects.equals(this.rank(), other.rank()) && Objects.equals(this.savingsOpportunity(), other.savingsOpportunity()) && Objects.equals(this.savingsOpportunityAfterDiscounts(), other.savingsOpportunityAfterDiscounts());
    }

    public final String toString() {
        return ToString.builder((String)"VolumeRecommendationOption").add("Configuration", (Object)this.configuration()).add("PerformanceRisk", (Object)this.performanceRisk()).add("Rank", (Object)this.rank()).add("SavingsOpportunity", (Object)this.savingsOpportunity()).add("SavingsOpportunityAfterDiscounts", (Object)this.savingsOpportunityAfterDiscounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "performanceRisk": {
                return Optional.ofNullable(clazz.cast(this.performanceRisk()));
            }
            case "rank": {
                return Optional.ofNullable(clazz.cast(this.rank()));
            }
            case "savingsOpportunity": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunity()));
            }
            case "savingsOpportunityAfterDiscounts": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunityAfterDiscounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VolumeRecommendationOption, T> g) {
        return obj -> g.apply((VolumeRecommendationOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VolumeConfiguration configuration;
        private Double performanceRisk;
        private Integer rank;
        private SavingsOpportunity savingsOpportunity;
        private EBSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeRecommendationOption model) {
            this.configuration(model.configuration);
            this.performanceRisk(model.performanceRisk);
            this.rank(model.rank);
            this.savingsOpportunity(model.savingsOpportunity);
            this.savingsOpportunityAfterDiscounts(model.savingsOpportunityAfterDiscounts);
        }

        public final VolumeConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(VolumeConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(VolumeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Double getPerformanceRisk() {
            return this.performanceRisk;
        }

        public final void setPerformanceRisk(Double performanceRisk) {
            this.performanceRisk = performanceRisk;
        }

        @Override
        public final Builder performanceRisk(Double performanceRisk) {
            this.performanceRisk = performanceRisk;
            return this;
        }

        public final Integer getRank() {
            return this.rank;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final SavingsOpportunity.Builder getSavingsOpportunity() {
            return this.savingsOpportunity != null ? this.savingsOpportunity.toBuilder() : null;
        }

        public final void setSavingsOpportunity(SavingsOpportunity.BuilderImpl savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity != null ? savingsOpportunity.build() : null;
        }

        @Override
        public final Builder savingsOpportunity(SavingsOpportunity savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity;
            return this;
        }

        public final EBSSavingsOpportunityAfterDiscounts.Builder getSavingsOpportunityAfterDiscounts() {
            return this.savingsOpportunityAfterDiscounts != null ? this.savingsOpportunityAfterDiscounts.toBuilder() : null;
        }

        public final void setSavingsOpportunityAfterDiscounts(EBSSavingsOpportunityAfterDiscounts.BuilderImpl savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts != null ? savingsOpportunityAfterDiscounts.build() : null;
        }

        @Override
        public final Builder savingsOpportunityAfterDiscounts(EBSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts;
            return this;
        }

        public VolumeRecommendationOption build() {
            return new VolumeRecommendationOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeRecommendationOption> {
        public Builder configuration(VolumeConfiguration var1);

        default public Builder configuration(Consumer<VolumeConfiguration.Builder> configuration) {
            return this.configuration((VolumeConfiguration)((VolumeConfiguration.Builder)VolumeConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder performanceRisk(Double var1);

        public Builder rank(Integer var1);

        public Builder savingsOpportunity(SavingsOpportunity var1);

        default public Builder savingsOpportunity(Consumer<SavingsOpportunity.Builder> savingsOpportunity) {
            return this.savingsOpportunity((SavingsOpportunity)((SavingsOpportunity.Builder)SavingsOpportunity.builder().applyMutation(savingsOpportunity)).build());
        }

        public Builder savingsOpportunityAfterDiscounts(EBSSavingsOpportunityAfterDiscounts var1);

        default public Builder savingsOpportunityAfterDiscounts(Consumer<EBSSavingsOpportunityAfterDiscounts.Builder> savingsOpportunityAfterDiscounts) {
            return this.savingsOpportunityAfterDiscounts((EBSSavingsOpportunityAfterDiscounts)((EBSSavingsOpportunityAfterDiscounts.Builder)EBSSavingsOpportunityAfterDiscounts.builder().applyMutation(savingsOpportunityAfterDiscounts)).build());
        }
    }
}

