/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizer.ComputeOptimizerClient;
import software.amazon.awssdk.services.computeoptimizer.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationExportJob;

public class DescribeRecommendationExportJobsIterable
implements SdkIterable<DescribeRecommendationExportJobsResponse> {
    private final ComputeOptimizerClient client;
    private final DescribeRecommendationExportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRecommendationExportJobsIterable(ComputeOptimizerClient client, DescribeRecommendationExportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRecommendationExportJobsResponseFetcher();
    }

    public Iterator<DescribeRecommendationExportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecommendationExportJob> recommendationExportJobs() {
        Function<DescribeRecommendationExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommendationExportJobs() != null) {
                return response.recommendationExportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRecommendationExportJobsResponseFetcher
    implements SyncPageFetcher<DescribeRecommendationExportJobsResponse> {
        private DescribeRecommendationExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRecommendationExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRecommendationExportJobsResponse nextPage(DescribeRecommendationExportJobsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRecommendationExportJobsIterable.this.client.describeRecommendationExportJobs(DescribeRecommendationExportJobsIterable.this.firstRequest);
            }
            return DescribeRecommendationExportJobsIterable.this.client.describeRecommendationExportJobs((DescribeRecommendationExportJobsRequest)((Object)DescribeRecommendationExportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

