/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum InstanceRecommendationFindingReasonCode {
    CPU_OVERPROVISIONED("CPUOverprovisioned"),

    CPU_UNDERPROVISIONED("CPUUnderprovisioned"),

    MEMORY_OVERPROVISIONED("MemoryOverprovisioned"),

    MEMORY_UNDERPROVISIONED("MemoryUnderprovisioned"),

    EBS_THROUGHPUT_OVERPROVISIONED("EBSThroughputOverprovisioned"),

    EBS_THROUGHPUT_UNDERPROVISIONED("EBSThroughputUnderprovisioned"),

    EBSIOPS_OVERPROVISIONED("EBSIOPSOverprovisioned"),

    EBSIOPS_UNDERPROVISIONED("EBSIOPSUnderprovisioned"),

    NETWORK_BANDWIDTH_OVERPROVISIONED("NetworkBandwidthOverprovisioned"),

    NETWORK_BANDWIDTH_UNDERPROVISIONED("NetworkBandwidthUnderprovisioned"),

    NETWORK_PPS_OVERPROVISIONED("NetworkPPSOverprovisioned"),

    NETWORK_PPS_UNDERPROVISIONED("NetworkPPSUnderprovisioned"),

    DISK_IOPS_OVERPROVISIONED("DiskIOPSOverprovisioned"),

    DISK_IOPS_UNDERPROVISIONED("DiskIOPSUnderprovisioned"),

    DISK_THROUGHPUT_OVERPROVISIONED("DiskThroughputOverprovisioned"),

    DISK_THROUGHPUT_UNDERPROVISIONED("DiskThroughputUnderprovisioned"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceRecommendationFindingReasonCode> VALUE_MAP = EnumUtils.uniqueIndex(
            InstanceRecommendationFindingReasonCode.class, InstanceRecommendationFindingReasonCode::toString);

    private final String value;

    private InstanceRecommendationFindingReasonCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return InstanceRecommendationFindingReasonCode corresponding to the value
     */
    public static InstanceRecommendationFindingReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link InstanceRecommendationFindingReasonCode}s
     */
    public static Set<InstanceRecommendationFindingReasonCode> knownValues() {
        Set<InstanceRecommendationFindingReasonCode> knownValues = EnumSet.allOf(InstanceRecommendationFindingReasonCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
