/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLambdaFunctionRecommendationsResponse extends ComputeOptimizerResponse implements
        ToCopyableBuilder<GetLambdaFunctionRecommendationsResponse.Builder, GetLambdaFunctionRecommendationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetLambdaFunctionRecommendationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<LambdaFunctionRecommendation>> LAMBDA_FUNCTION_RECOMMENDATIONS_FIELD = SdkField
            .<List<LambdaFunctionRecommendation>> builder(MarshallingType.LIST)
            .memberName("lambdaFunctionRecommendations")
            .getter(getter(GetLambdaFunctionRecommendationsResponse::lambdaFunctionRecommendations))
            .setter(setter(Builder::lambdaFunctionRecommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionRecommendations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LambdaFunctionRecommendation> builder(MarshallingType.SDK_POJO)
                                            .constructor(LambdaFunctionRecommendation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            LAMBDA_FUNCTION_RECOMMENDATIONS_FIELD));

    private final String nextToken;

    private final List<LambdaFunctionRecommendation> lambdaFunctionRecommendations;

    private GetLambdaFunctionRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.lambdaFunctionRecommendations = builder.lambdaFunctionRecommendations;
    }

    /**
     * <p>
     * The token to use to advance to the next page of function recommendations.
     * </p>
     * <p>
     * This value is null when there are no more pages of function recommendations to return.
     * </p>
     * 
     * @return The token to use to advance to the next page of function recommendations.</p>
     *         <p>
     *         This value is null when there are no more pages of function recommendations to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LambdaFunctionRecommendations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLambdaFunctionRecommendations() {
        return lambdaFunctionRecommendations != null && !(lambdaFunctionRecommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe function recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLambdaFunctionRecommendations} method.
     * </p>
     * 
     * @return An array of objects that describe function recommendations.
     */
    public final List<LambdaFunctionRecommendation> lambdaFunctionRecommendations() {
        return lambdaFunctionRecommendations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasLambdaFunctionRecommendations() ? lambdaFunctionRecommendations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLambdaFunctionRecommendationsResponse)) {
            return false;
        }
        GetLambdaFunctionRecommendationsResponse other = (GetLambdaFunctionRecommendationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasLambdaFunctionRecommendations() == other.hasLambdaFunctionRecommendations()
                && Objects.equals(lambdaFunctionRecommendations(), other.lambdaFunctionRecommendations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetLambdaFunctionRecommendationsResponse")
                .add("NextToken", nextToken())
                .add("LambdaFunctionRecommendations", hasLambdaFunctionRecommendations() ? lambdaFunctionRecommendations() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "lambdaFunctionRecommendations":
            return Optional.ofNullable(clazz.cast(lambdaFunctionRecommendations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLambdaFunctionRecommendationsResponse, T> g) {
        return obj -> g.apply((GetLambdaFunctionRecommendationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComputeOptimizerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLambdaFunctionRecommendationsResponse> {
        /**
         * <p>
         * The token to use to advance to the next page of function recommendations.
         * </p>
         * <p>
         * This value is null when there are no more pages of function recommendations to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to advance to the next page of function recommendations.</p>
         *        <p>
         *        This value is null when there are no more pages of function recommendations to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of objects that describe function recommendations.
         * </p>
         * 
         * @param lambdaFunctionRecommendations
         *        An array of objects that describe function recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionRecommendations(Collection<LambdaFunctionRecommendation> lambdaFunctionRecommendations);

        /**
         * <p>
         * An array of objects that describe function recommendations.
         * </p>
         * 
         * @param lambdaFunctionRecommendations
         *        An array of objects that describe function recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionRecommendations(LambdaFunctionRecommendation... lambdaFunctionRecommendations);

        /**
         * <p>
         * An array of objects that describe function recommendations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendation.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendation.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #lambdaFunctionRecommendations(List<LambdaFunctionRecommendation>)}.
         * 
         * @param lambdaFunctionRecommendations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionRecommendations(java.util.Collection<LambdaFunctionRecommendation>)
         */
        Builder lambdaFunctionRecommendations(Consumer<LambdaFunctionRecommendation.Builder>... lambdaFunctionRecommendations);
    }

    static final class BuilderImpl extends ComputeOptimizerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<LambdaFunctionRecommendation> lambdaFunctionRecommendations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLambdaFunctionRecommendationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            lambdaFunctionRecommendations(model.lambdaFunctionRecommendations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<LambdaFunctionRecommendation.Builder> getLambdaFunctionRecommendations() {
            List<LambdaFunctionRecommendation.Builder> result = LambdaFunctionRecommendationsCopier
                    .copyToBuilder(this.lambdaFunctionRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLambdaFunctionRecommendations(
                Collection<LambdaFunctionRecommendation.BuilderImpl> lambdaFunctionRecommendations) {
            this.lambdaFunctionRecommendations = LambdaFunctionRecommendationsCopier
                    .copyFromBuilder(lambdaFunctionRecommendations);
        }

        @Override
        public final Builder lambdaFunctionRecommendations(Collection<LambdaFunctionRecommendation> lambdaFunctionRecommendations) {
            this.lambdaFunctionRecommendations = LambdaFunctionRecommendationsCopier.copy(lambdaFunctionRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionRecommendations(LambdaFunctionRecommendation... lambdaFunctionRecommendations) {
            lambdaFunctionRecommendations(Arrays.asList(lambdaFunctionRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionRecommendations(
                Consumer<LambdaFunctionRecommendation.Builder>... lambdaFunctionRecommendations) {
            lambdaFunctionRecommendations(Stream.of(lambdaFunctionRecommendations)
                    .map(c -> LambdaFunctionRecommendation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetLambdaFunctionRecommendationsResponse build() {
            return new GetLambdaFunctionRecommendationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
