/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEnrollmentStatusResponse extends ComputeOptimizerResponse implements
        ToCopyableBuilder<GetEnrollmentStatusResponse.Builder, GetEnrollmentStatusResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetEnrollmentStatusResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(GetEnrollmentStatusResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Boolean> MEMBER_ACCOUNTS_ENROLLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("memberAccountsEnrolled").getter(getter(GetEnrollmentStatusResponse::memberAccountsEnrolled))
            .setter(setter(Builder::memberAccountsEnrolled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountsEnrolled").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedTimestamp").getter(getter(GetEnrollmentStatusResponse::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTimestamp").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_MEMBER_ACCOUNTS_OPTED_IN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfMemberAccountsOptedIn")
            .getter(getter(GetEnrollmentStatusResponse::numberOfMemberAccountsOptedIn))
            .setter(setter(Builder::numberOfMemberAccountsOptedIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfMemberAccountsOptedIn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STATUS_REASON_FIELD, MEMBER_ACCOUNTS_ENROLLED_FIELD, LAST_UPDATED_TIMESTAMP_FIELD,
            NUMBER_OF_MEMBER_ACCOUNTS_OPTED_IN_FIELD));

    private final String status;

    private final String statusReason;

    private final Boolean memberAccountsEnrolled;

    private final Instant lastUpdatedTimestamp;

    private final Integer numberOfMemberAccountsOptedIn;

    private GetEnrollmentStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.memberAccountsEnrolled = builder.memberAccountsEnrolled;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.numberOfMemberAccountsOptedIn = builder.numberOfMemberAccountsOptedIn;
    }

    /**
     * <p>
     * The enrollment status of the account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The enrollment status of the account.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The enrollment status of the account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The enrollment status of the account.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the enrollment status of the account.
     * </p>
     * <p>
     * For example, an account might show a status of <code>Pending</code> because member accounts of an organization
     * require more time to be enrolled in the service.
     * </p>
     * 
     * @return The reason for the enrollment status of the account.</p>
     *         <p>
     *         For example, an account might show a status of <code>Pending</code> because member accounts of an
     *         organization require more time to be enrolled in the service.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * Confirms the enrollment status of member accounts of the organization, if the account is a management account of
     * an organization.
     * </p>
     * 
     * @return Confirms the enrollment status of member accounts of the organization, if the account is a management
     *         account of an organization.
     */
    public final Boolean memberAccountsEnrolled() {
        return memberAccountsEnrolled;
    }

    /**
     * <p>
     * The Unix epoch timestamp, in seconds, of when the account enrollment status was last updated.
     * </p>
     * 
     * @return The Unix epoch timestamp, in seconds, of when the account enrollment status was last updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The count of organization member accounts that are opted in to the service, if your account is an organization
     * management account.
     * </p>
     * 
     * @return The count of organization member accounts that are opted in to the service, if your account is an
     *         organization management account.
     */
    public final Integer numberOfMemberAccountsOptedIn() {
        return numberOfMemberAccountsOptedIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(memberAccountsEnrolled());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfMemberAccountsOptedIn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnrollmentStatusResponse)) {
            return false;
        }
        GetEnrollmentStatusResponse other = (GetEnrollmentStatusResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(memberAccountsEnrolled(), other.memberAccountsEnrolled())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp())
                && Objects.equals(numberOfMemberAccountsOptedIn(), other.numberOfMemberAccountsOptedIn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEnrollmentStatusResponse").add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("MemberAccountsEnrolled", memberAccountsEnrolled())
                .add("LastUpdatedTimestamp", lastUpdatedTimestamp())
                .add("NumberOfMemberAccountsOptedIn", numberOfMemberAccountsOptedIn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "memberAccountsEnrolled":
            return Optional.ofNullable(clazz.cast(memberAccountsEnrolled()));
        case "lastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        case "numberOfMemberAccountsOptedIn":
            return Optional.ofNullable(clazz.cast(numberOfMemberAccountsOptedIn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEnrollmentStatusResponse, T> g) {
        return obj -> g.apply((GetEnrollmentStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComputeOptimizerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEnrollmentStatusResponse> {
        /**
         * <p>
         * The enrollment status of the account.
         * </p>
         * 
         * @param status
         *        The enrollment status of the account.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The enrollment status of the account.
         * </p>
         * 
         * @param status
         *        The enrollment status of the account.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The reason for the enrollment status of the account.
         * </p>
         * <p>
         * For example, an account might show a status of <code>Pending</code> because member accounts of an
         * organization require more time to be enrolled in the service.
         * </p>
         * 
         * @param statusReason
         *        The reason for the enrollment status of the account.</p>
         *        <p>
         *        For example, an account might show a status of <code>Pending</code> because member accounts of an
         *        organization require more time to be enrolled in the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * Confirms the enrollment status of member accounts of the organization, if the account is a management account
         * of an organization.
         * </p>
         * 
         * @param memberAccountsEnrolled
         *        Confirms the enrollment status of member accounts of the organization, if the account is a management
         *        account of an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccountsEnrolled(Boolean memberAccountsEnrolled);

        /**
         * <p>
         * The Unix epoch timestamp, in seconds, of when the account enrollment status was last updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The Unix epoch timestamp, in seconds, of when the account enrollment status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);

        /**
         * <p>
         * The count of organization member accounts that are opted in to the service, if your account is an
         * organization management account.
         * </p>
         * 
         * @param numberOfMemberAccountsOptedIn
         *        The count of organization member accounts that are opted in to the service, if your account is an
         *        organization management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfMemberAccountsOptedIn(Integer numberOfMemberAccountsOptedIn);
    }

    static final class BuilderImpl extends ComputeOptimizerResponse.BuilderImpl implements Builder {
        private String status;

        private String statusReason;

        private Boolean memberAccountsEnrolled;

        private Instant lastUpdatedTimestamp;

        private Integer numberOfMemberAccountsOptedIn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnrollmentStatusResponse model) {
            super(model);
            status(model.status);
            statusReason(model.statusReason);
            memberAccountsEnrolled(model.memberAccountsEnrolled);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            numberOfMemberAccountsOptedIn(model.numberOfMemberAccountsOptedIn);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Boolean getMemberAccountsEnrolled() {
            return memberAccountsEnrolled;
        }

        public final void setMemberAccountsEnrolled(Boolean memberAccountsEnrolled) {
            this.memberAccountsEnrolled = memberAccountsEnrolled;
        }

        @Override
        public final Builder memberAccountsEnrolled(Boolean memberAccountsEnrolled) {
            this.memberAccountsEnrolled = memberAccountsEnrolled;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final Integer getNumberOfMemberAccountsOptedIn() {
            return numberOfMemberAccountsOptedIn;
        }

        public final void setNumberOfMemberAccountsOptedIn(Integer numberOfMemberAccountsOptedIn) {
            this.numberOfMemberAccountsOptedIn = numberOfMemberAccountsOptedIn;
        }

        @Override
        public final Builder numberOfMemberAccountsOptedIn(Integer numberOfMemberAccountsOptedIn) {
            this.numberOfMemberAccountsOptedIn = numberOfMemberAccountsOptedIn;
            return this;
        }

        @Override
        public GetEnrollmentStatusResponse build() {
            return new GetEnrollmentStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
