/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the projected metrics of an Amazon ECS service recommendation option.
 * </p>
 * <p>
 * To determine the performance difference between your current Amazon ECS service and the recommended option, compare
 * the metric data of your service against its projected metric data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ECSServiceRecommendedOptionProjectedMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<ECSServiceRecommendedOptionProjectedMetric.Builder, ECSServiceRecommendedOptionProjectedMetric> {
    private static final SdkField<Integer> RECOMMENDED_CPU_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("recommendedCpuUnits").getter(getter(ECSServiceRecommendedOptionProjectedMetric::recommendedCpuUnits))
            .setter(setter(Builder::recommendedCpuUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedCpuUnits").build())
            .build();

    private static final SdkField<Integer> RECOMMENDED_MEMORY_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("recommendedMemorySize")
            .getter(getter(ECSServiceRecommendedOptionProjectedMetric::recommendedMemorySize))
            .setter(setter(Builder::recommendedMemorySize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedMemorySize").build())
            .build();

    private static final SdkField<List<ECSServiceProjectedMetric>> PROJECTED_METRICS_FIELD = SdkField
            .<List<ECSServiceProjectedMetric>> builder(MarshallingType.LIST)
            .memberName("projectedMetrics")
            .getter(getter(ECSServiceRecommendedOptionProjectedMetric::projectedMetrics))
            .setter(setter(Builder::projectedMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectedMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ECSServiceProjectedMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(ECSServiceProjectedMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDED_CPU_UNITS_FIELD,
            RECOMMENDED_MEMORY_SIZE_FIELD, PROJECTED_METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer recommendedCpuUnits;

    private final Integer recommendedMemorySize;

    private final List<ECSServiceProjectedMetric> projectedMetrics;

    private ECSServiceRecommendedOptionProjectedMetric(BuilderImpl builder) {
        this.recommendedCpuUnits = builder.recommendedCpuUnits;
        this.recommendedMemorySize = builder.recommendedMemorySize;
        this.projectedMetrics = builder.projectedMetrics;
    }

    /**
     * <p>
     * The recommended CPU size for the Amazon ECS service.
     * </p>
     * 
     * @return The recommended CPU size for the Amazon ECS service.
     */
    public final Integer recommendedCpuUnits() {
        return recommendedCpuUnits;
    }

    /**
     * <p>
     * The recommended memory size for the Amazon ECS service.
     * </p>
     * 
     * @return The recommended memory size for the Amazon ECS service.
     */
    public final Integer recommendedMemorySize() {
        return recommendedMemorySize;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProjectedMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProjectedMetrics() {
        return projectedMetrics != null && !(projectedMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the projected metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProjectedMetrics} method.
     * </p>
     * 
     * @return An array of objects that describe the projected metric.
     */
    public final List<ECSServiceProjectedMetric> projectedMetrics() {
        return projectedMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommendedCpuUnits());
        hashCode = 31 * hashCode + Objects.hashCode(recommendedMemorySize());
        hashCode = 31 * hashCode + Objects.hashCode(hasProjectedMetrics() ? projectedMetrics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ECSServiceRecommendedOptionProjectedMetric)) {
            return false;
        }
        ECSServiceRecommendedOptionProjectedMetric other = (ECSServiceRecommendedOptionProjectedMetric) obj;
        return Objects.equals(recommendedCpuUnits(), other.recommendedCpuUnits())
                && Objects.equals(recommendedMemorySize(), other.recommendedMemorySize())
                && hasProjectedMetrics() == other.hasProjectedMetrics()
                && Objects.equals(projectedMetrics(), other.projectedMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ECSServiceRecommendedOptionProjectedMetric").add("RecommendedCpuUnits", recommendedCpuUnits())
                .add("RecommendedMemorySize", recommendedMemorySize())
                .add("ProjectedMetrics", hasProjectedMetrics() ? projectedMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recommendedCpuUnits":
            return Optional.ofNullable(clazz.cast(recommendedCpuUnits()));
        case "recommendedMemorySize":
            return Optional.ofNullable(clazz.cast(recommendedMemorySize()));
        case "projectedMetrics":
            return Optional.ofNullable(clazz.cast(projectedMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ECSServiceRecommendedOptionProjectedMetric, T> g) {
        return obj -> g.apply((ECSServiceRecommendedOptionProjectedMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ECSServiceRecommendedOptionProjectedMetric> {
        /**
         * <p>
         * The recommended CPU size for the Amazon ECS service.
         * </p>
         * 
         * @param recommendedCpuUnits
         *        The recommended CPU size for the Amazon ECS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedCpuUnits(Integer recommendedCpuUnits);

        /**
         * <p>
         * The recommended memory size for the Amazon ECS service.
         * </p>
         * 
         * @param recommendedMemorySize
         *        The recommended memory size for the Amazon ECS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedMemorySize(Integer recommendedMemorySize);

        /**
         * <p>
         * An array of objects that describe the projected metric.
         * </p>
         * 
         * @param projectedMetrics
         *        An array of objects that describe the projected metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectedMetrics(Collection<ECSServiceProjectedMetric> projectedMetrics);

        /**
         * <p>
         * An array of objects that describe the projected metric.
         * </p>
         * 
         * @param projectedMetrics
         *        An array of objects that describe the projected metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectedMetrics(ECSServiceProjectedMetric... projectedMetrics);

        /**
         * <p>
         * An array of objects that describe the projected metric.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedMetric.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedMetric.Builder#build()} is
         * called immediately and its result is passed to {@link #projectedMetrics(List<ECSServiceProjectedMetric>)}.
         * 
         * @param projectedMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectedMetrics(java.util.Collection<ECSServiceProjectedMetric>)
         */
        Builder projectedMetrics(Consumer<ECSServiceProjectedMetric.Builder>... projectedMetrics);
    }

    static final class BuilderImpl implements Builder {
        private Integer recommendedCpuUnits;

        private Integer recommendedMemorySize;

        private List<ECSServiceProjectedMetric> projectedMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ECSServiceRecommendedOptionProjectedMetric model) {
            recommendedCpuUnits(model.recommendedCpuUnits);
            recommendedMemorySize(model.recommendedMemorySize);
            projectedMetrics(model.projectedMetrics);
        }

        public final Integer getRecommendedCpuUnits() {
            return recommendedCpuUnits;
        }

        public final void setRecommendedCpuUnits(Integer recommendedCpuUnits) {
            this.recommendedCpuUnits = recommendedCpuUnits;
        }

        @Override
        public final Builder recommendedCpuUnits(Integer recommendedCpuUnits) {
            this.recommendedCpuUnits = recommendedCpuUnits;
            return this;
        }

        public final Integer getRecommendedMemorySize() {
            return recommendedMemorySize;
        }

        public final void setRecommendedMemorySize(Integer recommendedMemorySize) {
            this.recommendedMemorySize = recommendedMemorySize;
        }

        @Override
        public final Builder recommendedMemorySize(Integer recommendedMemorySize) {
            this.recommendedMemorySize = recommendedMemorySize;
            return this;
        }

        public final List<ECSServiceProjectedMetric.Builder> getProjectedMetrics() {
            List<ECSServiceProjectedMetric.Builder> result = ECSServiceProjectedMetricsCopier
                    .copyToBuilder(this.projectedMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectedMetrics(Collection<ECSServiceProjectedMetric.BuilderImpl> projectedMetrics) {
            this.projectedMetrics = ECSServiceProjectedMetricsCopier.copyFromBuilder(projectedMetrics);
        }

        @Override
        public final Builder projectedMetrics(Collection<ECSServiceProjectedMetric> projectedMetrics) {
            this.projectedMetrics = ECSServiceProjectedMetricsCopier.copy(projectedMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedMetrics(ECSServiceProjectedMetric... projectedMetrics) {
            projectedMetrics(Arrays.asList(projectedMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedMetrics(Consumer<ECSServiceProjectedMetric.Builder>... projectedMetrics) {
            projectedMetrics(Stream.of(projectedMetrics).map(c -> ECSServiceProjectedMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ECSServiceRecommendedOptionProjectedMetric build() {
            return new ECSServiceRecommendedOptionProjectedMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
