/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType;
import software.amazon.awssdk.services.computeoptimizer.model.SummariesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.Summary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationSummary> {
    private static final SdkField<List<Summary>> SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("summaries").getter(RecommendationSummary.getter(RecommendationSummary::summaries)).setter(RecommendationSummary.setter(Builder::summaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Summary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECOMMENDATION_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationResourceType").getter(RecommendationSummary.getter(RecommendationSummary::recommendationResourceTypeAsString)).setter(RecommendationSummary.setter(Builder::recommendationResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationResourceType").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(RecommendationSummary.getter(RecommendationSummary::accountId)).setter(RecommendationSummary.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARIES_FIELD, RECOMMENDATION_RESOURCE_TYPE_FIELD, ACCOUNT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Summary> summaries;
    private final String recommendationResourceType;
    private final String accountId;

    private RecommendationSummary(BuilderImpl builder) {
        this.summaries = builder.summaries;
        this.recommendationResourceType = builder.recommendationResourceType;
        this.accountId = builder.accountId;
    }

    public final boolean hasSummaries() {
        return this.summaries != null && !(this.summaries instanceof SdkAutoConstructList);
    }

    public final List<Summary> summaries() {
        return this.summaries;
    }

    public final RecommendationSourceType recommendationResourceType() {
        return RecommendationSourceType.fromValue(this.recommendationResourceType);
    }

    public final String recommendationResourceTypeAsString() {
        return this.recommendationResourceType;
    }

    public final String accountId() {
        return this.accountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSummaries() ? this.summaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSummary)) {
            return false;
        }
        RecommendationSummary other = (RecommendationSummary)obj;
        return this.hasSummaries() == other.hasSummaries() && Objects.equals(this.summaries(), other.summaries()) && Objects.equals(this.recommendationResourceTypeAsString(), other.recommendationResourceTypeAsString()) && Objects.equals(this.accountId(), other.accountId());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationSummary").add("Summaries", this.hasSummaries() ? this.summaries() : null).add("RecommendationResourceType", (Object)this.recommendationResourceTypeAsString()).add("AccountId", (Object)this.accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "summaries": {
                return Optional.ofNullable(clazz.cast(this.summaries()));
            }
            case "recommendationResourceType": {
                return Optional.ofNullable(clazz.cast(this.recommendationResourceTypeAsString()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationSummary, T> g) {
        return obj -> g.apply((RecommendationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Summary> summaries = DefaultSdkAutoConstructList.getInstance();
        private String recommendationResourceType;
        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationSummary model) {
            this.summaries(model.summaries);
            this.recommendationResourceType(model.recommendationResourceType);
            this.accountId(model.accountId);
        }

        public final List<Summary.Builder> getSummaries() {
            List<Summary.Builder> result = SummariesCopier.copyToBuilder(this.summaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaries(Collection<Summary.BuilderImpl> summaries) {
            this.summaries = SummariesCopier.copyFromBuilder(summaries);
        }

        @Override
        @Transient
        public final Builder summaries(Collection<Summary> summaries) {
            this.summaries = SummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder summaries(Summary ... summaries) {
            this.summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder summaries(Consumer<Summary.Builder> ... summaries) {
            this.summaries(Stream.of(summaries).map(c -> (Summary)((Summary.Builder)Summary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRecommendationResourceType() {
            return this.recommendationResourceType;
        }

        public final void setRecommendationResourceType(String recommendationResourceType) {
            this.recommendationResourceType = recommendationResourceType;
        }

        @Override
        @Transient
        public final Builder recommendationResourceType(String recommendationResourceType) {
            this.recommendationResourceType = recommendationResourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder recommendationResourceType(RecommendationSourceType recommendationResourceType) {
            this.recommendationResourceType(recommendationResourceType == null ? null : recommendationResourceType.toString());
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public RecommendationSummary build() {
            return new RecommendationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationSummary> {
        public Builder summaries(Collection<Summary> var1);

        public Builder summaries(Summary ... var1);

        public Builder summaries(Consumer<Summary.Builder> ... var1);

        public Builder recommendationResourceType(String var1);

        public Builder recommendationResourceType(RecommendationSourceType var1);

        public Builder accountId(String var1);
    }
}

