/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PlatformDifference {
    HYPERVISOR("Hypervisor"),
    NETWORK_INTERFACE("NetworkInterface"),
    STORAGE_INTERFACE("StorageInterface"),
    INSTANCE_STORE_AVAILABILITY("InstanceStoreAvailability"),
    VIRTUALIZATION_TYPE("VirtualizationType"),
    ARCHITECTURE("Architecture"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PlatformDifference(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PlatformDifference fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PlatformDifference.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PlatformDifference> knownValues() {
        return Stream.of(PlatformDifference.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

