/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.AccountIdsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupArnsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerRequest;
import software.amazon.awssdk.services.computeoptimizer.model.Filter;
import software.amazon.awssdk.services.computeoptimizer.model.FiltersCopier;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferences;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAutoScalingGroupRecommendationsRequest
extends ComputeOptimizerRequest
implements ToCopyableBuilder<Builder, GetAutoScalingGroupRecommendationsRequest> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountIds").getter(GetAutoScalingGroupRecommendationsRequest.getter(GetAutoScalingGroupRecommendationsRequest::accountIds)).setter(GetAutoScalingGroupRecommendationsRequest.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AUTO_SCALING_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("autoScalingGroupArns").getter(GetAutoScalingGroupRecommendationsRequest.getter(GetAutoScalingGroupRecommendationsRequest::autoScalingGroupArns)).setter(GetAutoScalingGroupRecommendationsRequest.setter(Builder::autoScalingGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetAutoScalingGroupRecommendationsRequest.getter(GetAutoScalingGroupRecommendationsRequest::nextToken)).setter(GetAutoScalingGroupRecommendationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetAutoScalingGroupRecommendationsRequest.getter(GetAutoScalingGroupRecommendationsRequest::maxResults)).setter(GetAutoScalingGroupRecommendationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(GetAutoScalingGroupRecommendationsRequest.getter(GetAutoScalingGroupRecommendationsRequest::filters)).setter(GetAutoScalingGroupRecommendationsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RecommendationPreferences> RECOMMENDATION_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recommendationPreferences").getter(GetAutoScalingGroupRecommendationsRequest.getter(GetAutoScalingGroupRecommendationsRequest::recommendationPreferences)).setter(GetAutoScalingGroupRecommendationsRequest.setter(Builder::recommendationPreferences)).constructor(RecommendationPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationPreferences").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD, AUTO_SCALING_GROUP_ARNS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTERS_FIELD, RECOMMENDATION_PREFERENCES_FIELD));
    private final List<String> accountIds;
    private final List<String> autoScalingGroupArns;
    private final String nextToken;
    private final Integer maxResults;
    private final List<Filter> filters;
    private final RecommendationPreferences recommendationPreferences;

    private GetAutoScalingGroupRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.autoScalingGroupArns = builder.autoScalingGroupArns;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
        this.recommendationPreferences = builder.recommendationPreferences;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final boolean hasAutoScalingGroupArns() {
        return this.autoScalingGroupArns != null && !(this.autoScalingGroupArns instanceof SdkAutoConstructList);
    }

    public final List<String> autoScalingGroupArns() {
        return this.autoScalingGroupArns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final RecommendationPreferences recommendationPreferences() {
        return this.recommendationPreferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoScalingGroupArns() ? this.autoScalingGroupArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationPreferences());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutoScalingGroupRecommendationsRequest)) {
            return false;
        }
        GetAutoScalingGroupRecommendationsRequest other = (GetAutoScalingGroupRecommendationsRequest)((Object)obj);
        return this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && this.hasAutoScalingGroupArns() == other.hasAutoScalingGroupArns() && Objects.equals(this.autoScalingGroupArns(), other.autoScalingGroupArns()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.recommendationPreferences(), other.recommendationPreferences());
    }

    public final String toString() {
        return ToString.builder((String)"GetAutoScalingGroupRecommendationsRequest").add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("AutoScalingGroupArns", this.hasAutoScalingGroupArns() ? this.autoScalingGroupArns() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Filters", this.hasFilters() ? this.filters() : null).add("RecommendationPreferences", (Object)this.recommendationPreferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "autoScalingGroupArns": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupArns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "recommendationPreferences": {
                return Optional.ofNullable(clazz.cast(this.recommendationPreferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAutoScalingGroupRecommendationsRequest, T> g) {
        return obj -> g.apply((GetAutoScalingGroupRecommendationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerRequest.BuilderImpl
    implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> autoScalingGroupArns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private RecommendationPreferences recommendationPreferences;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutoScalingGroupRecommendationsRequest model) {
            super(model);
            this.accountIds(model.accountIds);
            this.autoScalingGroupArns(model.autoScalingGroupArns);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.filters(model.filters);
            this.recommendationPreferences(model.recommendationPreferences);
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        @Override
        @Transient
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getAutoScalingGroupArns() {
            if (this.autoScalingGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autoScalingGroupArns;
        }

        public final void setAutoScalingGroupArns(Collection<String> autoScalingGroupArns) {
            this.autoScalingGroupArns = AutoScalingGroupArnsCopier.copy(autoScalingGroupArns);
        }

        @Override
        @Transient
        public final Builder autoScalingGroupArns(Collection<String> autoScalingGroupArns) {
            this.autoScalingGroupArns = AutoScalingGroupArnsCopier.copy(autoScalingGroupArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder autoScalingGroupArns(String ... autoScalingGroupArns) {
            this.autoScalingGroupArns(Arrays.asList(autoScalingGroupArns));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RecommendationPreferences.Builder getRecommendationPreferences() {
            return this.recommendationPreferences != null ? this.recommendationPreferences.toBuilder() : null;
        }

        public final void setRecommendationPreferences(RecommendationPreferences.BuilderImpl recommendationPreferences) {
            this.recommendationPreferences = recommendationPreferences != null ? recommendationPreferences.build() : null;
        }

        @Override
        @Transient
        public final Builder recommendationPreferences(RecommendationPreferences recommendationPreferences) {
            this.recommendationPreferences = recommendationPreferences;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAutoScalingGroupRecommendationsRequest build() {
            return new GetAutoScalingGroupRecommendationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComputeOptimizerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAutoScalingGroupRecommendationsRequest> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder autoScalingGroupArns(Collection<String> var1);

        public Builder autoScalingGroupArns(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder recommendationPreferences(RecommendationPreferences var1);

        default public Builder recommendationPreferences(Consumer<RecommendationPreferences.Builder> recommendationPreferences) {
            return this.recommendationPreferences((RecommendationPreferences)((RecommendationPreferences.Builder)RecommendationPreferences.builder().applyMutation(recommendationPreferences)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

