/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.comprehendmedical.model.ComprehendMedicalResponse;
import software.amazon.awssdk.services.comprehendmedical.model.Entity;
import software.amazon.awssdk.services.comprehendmedical.model.EntityListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectPhiResponse
extends ComprehendMedicalResponse
implements ToCopyableBuilder<Builder, DetectPhiResponse> {
    private static final SdkField<List<Entity>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DetectPhiResponse.getter(DetectPhiResponse::entities)).setter(DetectPhiResponse.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Entity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DetectPhiResponse.getter(DetectPhiResponse::paginationToken)).setter(DetectPhiResponse.setter(Builder::paginationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD, PAGINATION_TOKEN_FIELD));
    private final List<Entity> entities;
    private final String paginationToken;

    private DetectPhiResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.paginationToken = builder.paginationToken;
    }

    public List<Entity> entities() {
        return this.entities;
    }

    public String paginationToken() {
        return this.paginationToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entities());
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectPhiResponse)) {
            return false;
        }
        DetectPhiResponse other = (DetectPhiResponse)((Object)obj);
        return Objects.equals(this.entities(), other.entities()) && Objects.equals(this.paginationToken(), other.paginationToken());
    }

    public String toString() {
        return ToString.builder((String)"DetectPhiResponse").add("Entities", this.entities()).add("PaginationToken", (Object)this.paginationToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
            case "PaginationToken": {
                return Optional.ofNullable(clazz.cast(this.paginationToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectPhiResponse, T> g) {
        return obj -> g.apply((DetectPhiResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendMedicalResponse.BuilderImpl
    implements Builder {
        private List<Entity> entities = DefaultSdkAutoConstructList.getInstance();
        private String paginationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectPhiResponse model) {
            super(model);
            this.entities(model.entities);
            this.paginationToken(model.paginationToken);
        }

        public final Collection<Entity.Builder> getEntities() {
            return this.entities != null ? (Collection)this.entities.stream().map(Entity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entities(Collection<Entity> entities) {
            this.entities = EntityListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Entity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<Entity.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (Entity)((Entity.Builder)Entity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntities(Collection<Entity.BuilderImpl> entities) {
            this.entities = EntityListCopier.copyFromBuilder(entities);
        }

        public final String getPaginationToken() {
            return this.paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public DetectPhiResponse build() {
            return new DetectPhiResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendMedicalResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectPhiResponse> {
        public Builder entities(Collection<Entity> var1);

        public Builder entities(Entity ... var1);

        public Builder entities(Consumer<Entity.Builder> ... var1);

        public Builder paginationToken(String var1);
    }
}

