/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.comprehendmedical.model.EntitySubType;
import software.amazon.awssdk.services.comprehendmedical.model.Trait;
import software.amazon.awssdk.services.comprehendmedical.model.TraitListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Attribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Attribute> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Attribute.getter(Attribute::typeAsString)).setter(Attribute.setter(Builder::type)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Float> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(Attribute.getter(Attribute::score)).setter(Attribute.setter(Builder::score)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final SdkField<Float> RELATIONSHIP_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(Attribute.getter(Attribute::relationshipScore)).setter(Attribute.setter(Builder::relationshipScore)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelationshipScore").build()}).build();
    private static final SdkField<Integer> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Attribute.getter(Attribute::id)).setter(Attribute.setter(Builder::id)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Attribute.getter(Attribute::beginOffset)).setter(Attribute.setter(Builder::beginOffset)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()}).build();
    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Attribute.getter(Attribute::endOffset)).setter(Attribute.setter(Builder::endOffset)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Attribute.getter(Attribute::text)).setter(Attribute.setter(Builder::text)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<List<Trait>> TRAITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Attribute.getter(Attribute::traits)).setter(Attribute.setter(Builder::traits)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Trait::builder).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, SCORE_FIELD, RELATIONSHIP_SCORE_FIELD, ID_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, TEXT_FIELD, TRAITS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Float score;
    private final Float relationshipScore;
    private final Integer id;
    private final Integer beginOffset;
    private final Integer endOffset;
    private final String text;
    private final List<Trait> traits;

    private Attribute(BuilderImpl builder) {
        this.type = builder.type;
        this.score = builder.score;
        this.relationshipScore = builder.relationshipScore;
        this.id = builder.id;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.text = builder.text;
        this.traits = builder.traits;
    }

    public EntitySubType type() {
        return EntitySubType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Float score() {
        return this.score;
    }

    public Float relationshipScore() {
        return this.relationshipScore;
    }

    public Integer id() {
        return this.id;
    }

    public Integer beginOffset() {
        return this.beginOffset;
    }

    public Integer endOffset() {
        return this.endOffset;
    }

    public String text() {
        return this.text;
    }

    public List<Trait> traits() {
        return this.traits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationshipScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.traits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.score(), other.score()) && Objects.equals(this.relationshipScore(), other.relationshipScore()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.beginOffset(), other.beginOffset()) && Objects.equals(this.endOffset(), other.endOffset()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.traits(), other.traits());
    }

    public String toString() {
        return ToString.builder((String)"Attribute").add("Type", (Object)this.typeAsString()).add("Score", (Object)this.score()).add("RelationshipScore", (Object)this.relationshipScore()).add("Id", (Object)this.id()).add("BeginOffset", (Object)this.beginOffset()).add("EndOffset", (Object)this.endOffset()).add("Text", (Object)this.text()).add("Traits", this.traits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "RelationshipScore": {
                return Optional.ofNullable(clazz.cast(this.relationshipScore()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "BeginOffset": {
                return Optional.ofNullable(clazz.cast(this.beginOffset()));
            }
            case "EndOffset": {
                return Optional.ofNullable(clazz.cast(this.endOffset()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "Traits": {
                return Optional.ofNullable(clazz.cast(this.traits()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Attribute, T> g) {
        return obj -> g.apply((Attribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Float score;
        private Float relationshipScore;
        private Integer id;
        private Integer beginOffset;
        private Integer endOffset;
        private String text;
        private List<Trait> traits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Attribute model) {
            this.type(model.type);
            this.score(model.score);
            this.relationshipScore(model.relationshipScore);
            this.id(model.id);
            this.beginOffset(model.beginOffset);
            this.endOffset(model.endOffset);
            this.text(model.text);
            this.traits(model.traits);
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EntitySubType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Float getScore() {
            return this.score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        public final Float getRelationshipScore() {
            return this.relationshipScore;
        }

        @Override
        public final Builder relationshipScore(Float relationshipScore) {
            this.relationshipScore = relationshipScore;
            return this;
        }

        public final void setRelationshipScore(Float relationshipScore) {
            this.relationshipScore = relationshipScore;
        }

        public final Integer getId() {
            return this.id;
        }

        @Override
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getBeginOffset() {
            return this.beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        public final Integer getEndOffset() {
            return this.endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final Collection<Trait.Builder> getTraits() {
            return this.traits != null ? (Collection)this.traits.stream().map(Trait::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder traits(Collection<Trait> traits) {
            this.traits = TraitListCopier.copy(traits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traits(Trait ... traits) {
            this.traits(Arrays.asList(traits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traits(Consumer<Trait.Builder> ... traits) {
            this.traits(Stream.of(traits).map(c -> (Trait)((Trait.Builder)Trait.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTraits(Collection<Trait.BuilderImpl> traits) {
            this.traits = TraitListCopier.copyFromBuilder(traits);
        }

        public Attribute build() {
            return new Attribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Attribute> {
        public Builder type(String var1);

        public Builder type(EntitySubType var1);

        public Builder score(Float var1);

        public Builder relationshipScore(Float var1);

        public Builder id(Integer var1);

        public Builder beginOffset(Integer var1);

        public Builder endOffset(Integer var1);

        public Builder text(String var1);

        public Builder traits(Collection<Trait> var1);

        public Builder traits(Trait ... var1);

        public Builder traits(Consumer<Trait.Builder> ... var1);
    }
}

