/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RelationshipType {
    EVERY("EVERY"),
    WITH_DOSAGE("WITH_DOSAGE"),
    ADMINISTERED_VIA("ADMINISTERED_VIA"),
    FOR("FOR"),
    NEGATIVE("NEGATIVE"),
    OVERLAP("OVERLAP"),
    DOSAGE("DOSAGE"),
    ROUTE_OR_MODE("ROUTE_OR_MODE"),
    FORM("FORM"),
    FREQUENCY("FREQUENCY"),
    DURATION("DURATION"),
    STRENGTH("STRENGTH"),
    RATE("RATE"),
    ACUITY("ACUITY"),
    TEST_VALUE("TEST_VALUE"),
    TEST_UNITS("TEST_UNITS"),
    DIRECTION("DIRECTION"),
    SYSTEM_ORGAN_SITE("SYSTEM_ORGAN_SITE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RelationshipType> VALUE_MAP;
    private final String value;

    private RelationshipType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RelationshipType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RelationshipType> knownValues() {
        EnumSet<RelationshipType> knownValues = EnumSet.allOf(RelationshipType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RelationshipType.class, RelationshipType::toString);
    }
}

