/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An extracted segment of the text that is an attribute of an entity, or otherwise related to an entity, such as the
 * dosage of a medication taken. It contains information about the attribute such as id, begin and end offset within the
 * input text, and the segment of the input text.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Attribute implements SdkPojo, Serializable, ToCopyableBuilder<Attribute.Builder, Attribute> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Attribute::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Float> SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Score")
            .getter(getter(Attribute::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final SdkField<Float> RELATIONSHIP_SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("RelationshipScore").getter(getter(Attribute::relationshipScore))
            .setter(setter(Builder::relationshipScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelationshipScore").build()).build();

    private static final SdkField<String> RELATIONSHIP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelationshipType").getter(getter(Attribute::relationshipTypeAsString))
            .setter(setter(Builder::relationshipType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelationshipType").build()).build();

    private static final SdkField<Integer> ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Id")
            .getter(getter(Attribute::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BeginOffset").getter(getter(Attribute::beginOffset)).setter(setter(Builder::beginOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()).build();

    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndOffset").getter(getter(Attribute::endOffset)).setter(setter(Builder::endOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(Attribute::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(Attribute::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<List<Trait>> TRAITS_FIELD = SdkField
            .<List<Trait>> builder(MarshallingType.LIST)
            .memberName("Traits")
            .getter(getter(Attribute::traits))
            .setter(setter(Builder::traits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Trait> builder(MarshallingType.SDK_POJO)
                                            .constructor(Trait::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, SCORE_FIELD,
            RELATIONSHIP_SCORE_FIELD, RELATIONSHIP_TYPE_FIELD, ID_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, TEXT_FIELD,
            CATEGORY_FIELD, TRAITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Float score;

    private final Float relationshipScore;

    private final String relationshipType;

    private final Integer id;

    private final Integer beginOffset;

    private final Integer endOffset;

    private final String text;

    private final String category;

    private final List<Trait> traits;

    private Attribute(BuilderImpl builder) {
        this.type = builder.type;
        this.score = builder.score;
        this.relationshipScore = builder.relationshipScore;
        this.relationshipType = builder.relationshipType;
        this.id = builder.id;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.text = builder.text;
        this.category = builder.category;
        this.traits = builder.traits;
    }

    /**
     * <p>
     * The type of attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EntitySubType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of attribute.
     * @see EntitySubType
     */
    public final EntitySubType type() {
        return EntitySubType.fromValue(type);
    }

    /**
     * <p>
     * The type of attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EntitySubType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of attribute.
     * @see EntitySubType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The level of confidence that Comprehend Medical; has that the segment of text is correctly recognized as an
     * attribute.
     * </p>
     * 
     * @return The level of confidence that Comprehend Medical; has that the segment of text is correctly recognized as
     *         an attribute.
     */
    public final Float score() {
        return score;
    }

    /**
     * <p>
     * The level of confidence that Comprehend Medical; has that this attribute is correctly related to this entity.
     * </p>
     * 
     * @return The level of confidence that Comprehend Medical; has that this attribute is correctly related to this
     *         entity.
     */
    public final Float relationshipScore() {
        return relationshipScore;
    }

    /**
     * <p>
     * The type of relationship between the entity and attribute. Type for the relationship is <code>OVERLAP</code>,
     * indicating that the entity occurred at the same time as the <code>Date_Expression</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relationshipType}
     * will return {@link RelationshipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relationshipTypeAsString}.
     * </p>
     * 
     * @return The type of relationship between the entity and attribute. Type for the relationship is
     *         <code>OVERLAP</code>, indicating that the entity occurred at the same time as the
     *         <code>Date_Expression</code>.
     * @see RelationshipType
     */
    public final RelationshipType relationshipType() {
        return RelationshipType.fromValue(relationshipType);
    }

    /**
     * <p>
     * The type of relationship between the entity and attribute. Type for the relationship is <code>OVERLAP</code>,
     * indicating that the entity occurred at the same time as the <code>Date_Expression</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relationshipType}
     * will return {@link RelationshipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relationshipTypeAsString}.
     * </p>
     * 
     * @return The type of relationship between the entity and attribute. Type for the relationship is
     *         <code>OVERLAP</code>, indicating that the entity occurred at the same time as the
     *         <code>Date_Expression</code>.
     * @see RelationshipType
     */
    public final String relationshipTypeAsString() {
        return relationshipType;
    }

    /**
     * <p>
     * The numeric identifier for this attribute. This is a monotonically increasing id unique within this response
     * rather than a global unique identifier.
     * </p>
     * 
     * @return The numeric identifier for this attribute. This is a monotonically increasing id unique within this
     *         response rather than a global unique identifier.
     */
    public final Integer id() {
        return id;
    }

    /**
     * <p>
     * The 0-based character offset in the input text that shows where the attribute begins. The offset returns the
     * UTF-8 code point in the string.
     * </p>
     * 
     * @return The 0-based character offset in the input text that shows where the attribute begins. The offset returns
     *         the UTF-8 code point in the string.
     */
    public final Integer beginOffset() {
        return beginOffset;
    }

    /**
     * <p>
     * The 0-based character offset in the input text that shows where the attribute ends. The offset returns the UTF-8
     * code point in the string.
     * </p>
     * 
     * @return The 0-based character offset in the input text that shows where the attribute ends. The offset returns
     *         the UTF-8 code point in the string.
     */
    public final Integer endOffset() {
        return endOffset;
    }

    /**
     * <p>
     * The segment of input text extracted as this attribute.
     * </p>
     * 
     * @return The segment of input text extracted as this attribute.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The category of attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of attribute.
     * @see EntityType
     */
    public final EntityType category() {
        return EntityType.fromValue(category);
    }

    /**
     * <p>
     * The category of attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of attribute.
     * @see EntityType
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * For responses, this returns true if the service returned a value for the Traits property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTraits() {
        return traits != null && !(traits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contextual information for this attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTraits} method.
     * </p>
     * 
     * @return Contextual information for this attribute.
     */
    public final List<Trait> traits() {
        return traits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(relationshipScore());
        hashCode = 31 * hashCode + Objects.hashCode(relationshipTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTraits() ? traits() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(score(), other.score())
                && Objects.equals(relationshipScore(), other.relationshipScore())
                && Objects.equals(relationshipTypeAsString(), other.relationshipTypeAsString())
                && Objects.equals(id(), other.id()) && Objects.equals(beginOffset(), other.beginOffset())
                && Objects.equals(endOffset(), other.endOffset()) && Objects.equals(text(), other.text())
                && Objects.equals(categoryAsString(), other.categoryAsString()) && hasTraits() == other.hasTraits()
                && Objects.equals(traits(), other.traits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Attribute").add("Type", typeAsString()).add("Score", score())
                .add("RelationshipScore", relationshipScore()).add("RelationshipType", relationshipTypeAsString())
                .add("Id", id()).add("BeginOffset", beginOffset()).add("EndOffset", endOffset()).add("Text", text())
                .add("Category", categoryAsString()).add("Traits", hasTraits() ? traits() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        case "RelationshipScore":
            return Optional.ofNullable(clazz.cast(relationshipScore()));
        case "RelationshipType":
            return Optional.ofNullable(clazz.cast(relationshipTypeAsString()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "BeginOffset":
            return Optional.ofNullable(clazz.cast(beginOffset()));
        case "EndOffset":
            return Optional.ofNullable(clazz.cast(endOffset()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "Category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "Traits":
            return Optional.ofNullable(clazz.cast(traits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Attribute, T> g) {
        return obj -> g.apply((Attribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Attribute> {
        /**
         * <p>
         * The type of attribute.
         * </p>
         * 
         * @param type
         *        The type of attribute.
         * @see EntitySubType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntitySubType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of attribute.
         * </p>
         * 
         * @param type
         *        The type of attribute.
         * @see EntitySubType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntitySubType
         */
        Builder type(EntitySubType type);

        /**
         * <p>
         * The level of confidence that Comprehend Medical; has that the segment of text is correctly recognized as an
         * attribute.
         * </p>
         * 
         * @param score
         *        The level of confidence that Comprehend Medical; has that the segment of text is correctly recognized
         *        as an attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Float score);

        /**
         * <p>
         * The level of confidence that Comprehend Medical; has that this attribute is correctly related to this entity.
         * </p>
         * 
         * @param relationshipScore
         *        The level of confidence that Comprehend Medical; has that this attribute is correctly related to this
         *        entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationshipScore(Float relationshipScore);

        /**
         * <p>
         * The type of relationship between the entity and attribute. Type for the relationship is <code>OVERLAP</code>,
         * indicating that the entity occurred at the same time as the <code>Date_Expression</code>.
         * </p>
         * 
         * @param relationshipType
         *        The type of relationship between the entity and attribute. Type for the relationship is
         *        <code>OVERLAP</code>, indicating that the entity occurred at the same time as the
         *        <code>Date_Expression</code>.
         * @see RelationshipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationshipType
         */
        Builder relationshipType(String relationshipType);

        /**
         * <p>
         * The type of relationship between the entity and attribute. Type for the relationship is <code>OVERLAP</code>,
         * indicating that the entity occurred at the same time as the <code>Date_Expression</code>.
         * </p>
         * 
         * @param relationshipType
         *        The type of relationship between the entity and attribute. Type for the relationship is
         *        <code>OVERLAP</code>, indicating that the entity occurred at the same time as the
         *        <code>Date_Expression</code>.
         * @see RelationshipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationshipType
         */
        Builder relationshipType(RelationshipType relationshipType);

        /**
         * <p>
         * The numeric identifier for this attribute. This is a monotonically increasing id unique within this response
         * rather than a global unique identifier.
         * </p>
         * 
         * @param id
         *        The numeric identifier for this attribute. This is a monotonically increasing id unique within this
         *        response rather than a global unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(Integer id);

        /**
         * <p>
         * The 0-based character offset in the input text that shows where the attribute begins. The offset returns the
         * UTF-8 code point in the string.
         * </p>
         * 
         * @param beginOffset
         *        The 0-based character offset in the input text that shows where the attribute begins. The offset
         *        returns the UTF-8 code point in the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffset(Integer beginOffset);

        /**
         * <p>
         * The 0-based character offset in the input text that shows where the attribute ends. The offset returns the
         * UTF-8 code point in the string.
         * </p>
         * 
         * @param endOffset
         *        The 0-based character offset in the input text that shows where the attribute ends. The offset returns
         *        the UTF-8 code point in the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffset(Integer endOffset);

        /**
         * <p>
         * The segment of input text extracted as this attribute.
         * </p>
         * 
         * @param text
         *        The segment of input text extracted as this attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The category of attribute.
         * </p>
         * 
         * @param category
         *        The category of attribute.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder category(String category);

        /**
         * <p>
         * The category of attribute.
         * </p>
         * 
         * @param category
         *        The category of attribute.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder category(EntityType category);

        /**
         * <p>
         * Contextual information for this attribute.
         * </p>
         * 
         * @param traits
         *        Contextual information for this attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traits(Collection<Trait> traits);

        /**
         * <p>
         * Contextual information for this attribute.
         * </p>
         * 
         * @param traits
         *        Contextual information for this attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traits(Trait... traits);

        /**
         * <p>
         * Contextual information for this attribute.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Trait>.Builder} avoiding the need to
         * create one manually via {@link List<Trait>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Trait>.Builder#build()} is called immediately and its result
         * is passed to {@link #traits(List<Trait>)}.
         * 
         * @param traits
         *        a consumer that will call methods on {@link List<Trait>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traits(List<Trait>)
         */
        Builder traits(Consumer<Trait.Builder>... traits);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Float score;

        private Float relationshipScore;

        private String relationshipType;

        private Integer id;

        private Integer beginOffset;

        private Integer endOffset;

        private String text;

        private String category;

        private List<Trait> traits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Attribute model) {
            type(model.type);
            score(model.score);
            relationshipScore(model.relationshipScore);
            relationshipType(model.relationshipType);
            id(model.id);
            beginOffset(model.beginOffset);
            endOffset(model.endOffset);
            text(model.text);
            category(model.category);
            traits(model.traits);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EntitySubType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Float getScore() {
            return score;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final Float getRelationshipScore() {
            return relationshipScore;
        }

        public final void setRelationshipScore(Float relationshipScore) {
            this.relationshipScore = relationshipScore;
        }

        @Override
        public final Builder relationshipScore(Float relationshipScore) {
            this.relationshipScore = relationshipScore;
            return this;
        }

        public final String getRelationshipType() {
            return relationshipType;
        }

        public final void setRelationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
        }

        @Override
        public final Builder relationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
            return this;
        }

        @Override
        public final Builder relationshipType(RelationshipType relationshipType) {
            this.relationshipType(relationshipType == null ? null : relationshipType.toString());
            return this;
        }

        public final Integer getId() {
            return id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        @Override
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final Integer getBeginOffset() {
            return beginOffset;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final Integer getEndOffset() {
            return endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(EntityType category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final List<Trait.Builder> getTraits() {
            List<Trait.Builder> result = TraitListCopier.copyToBuilder(this.traits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTraits(Collection<Trait.BuilderImpl> traits) {
            this.traits = TraitListCopier.copyFromBuilder(traits);
        }

        @Override
        public final Builder traits(Collection<Trait> traits) {
            this.traits = TraitListCopier.copy(traits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traits(Trait... traits) {
            traits(Arrays.asList(traits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traits(Consumer<Trait.Builder>... traits) {
            traits(Stream.of(traits).map(c -> Trait.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Attribute build() {
            return new Attribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
