/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The collection of medical entities extracted from the input text and their associated information. For each entity,
 * the response provides the entity text, the entity category, where the entity text begins and ends, and the level of
 * confidence that Amazon Comprehend Medical has in the detection and analysis. Attributes and traits of the entity are
 * also returned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RxNormEntity implements SdkPojo, Serializable, ToCopyableBuilder<RxNormEntity.Builder, RxNormEntity> {
    private static final SdkField<Integer> ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Id")
            .getter(getter(RxNormEntity::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(RxNormEntity::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(RxNormEntity::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RxNormEntity::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Float> SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Score")
            .getter(getter(RxNormEntity::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BeginOffset").getter(getter(RxNormEntity::beginOffset)).setter(setter(Builder::beginOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()).build();

    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndOffset").getter(getter(RxNormEntity::endOffset)).setter(setter(Builder::endOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()).build();

    private static final SdkField<List<RxNormAttribute>> ATTRIBUTES_FIELD = SdkField
            .<List<RxNormAttribute>> builder(MarshallingType.LIST)
            .memberName("Attributes")
            .getter(getter(RxNormEntity::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RxNormAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(RxNormAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RxNormTrait>> TRAITS_FIELD = SdkField
            .<List<RxNormTrait>> builder(MarshallingType.LIST)
            .memberName("Traits")
            .getter(getter(RxNormEntity::traits))
            .setter(setter(Builder::traits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RxNormTrait> builder(MarshallingType.SDK_POJO)
                                            .constructor(RxNormTrait::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RxNormConcept>> RX_NORM_CONCEPTS_FIELD = SdkField
            .<List<RxNormConcept>> builder(MarshallingType.LIST)
            .memberName("RxNormConcepts")
            .getter(getter(RxNormEntity::rxNormConcepts))
            .setter(setter(Builder::rxNormConcepts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RxNormConcepts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RxNormConcept> builder(MarshallingType.SDK_POJO)
                                            .constructor(RxNormConcept::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TEXT_FIELD,
            CATEGORY_FIELD, TYPE_FIELD, SCORE_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, ATTRIBUTES_FIELD, TRAITS_FIELD,
            RX_NORM_CONCEPTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer id;

    private final String text;

    private final String category;

    private final String type;

    private final Float score;

    private final Integer beginOffset;

    private final Integer endOffset;

    private final List<RxNormAttribute> attributes;

    private final List<RxNormTrait> traits;

    private final List<RxNormConcept> rxNormConcepts;

    private RxNormEntity(BuilderImpl builder) {
        this.id = builder.id;
        this.text = builder.text;
        this.category = builder.category;
        this.type = builder.type;
        this.score = builder.score;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.attributes = builder.attributes;
        this.traits = builder.traits;
        this.rxNormConcepts = builder.rxNormConcepts;
    }

    /**
     * <p>
     * The numeric identifier for the entity. This is a monotonically increasing id unique within this response rather
     * than a global unique identifier.
     * </p>
     * 
     * @return The numeric identifier for the entity. This is a monotonically increasing id unique within this response
     *         rather than a global unique identifier.
     */
    public final Integer id() {
        return id;
    }

    /**
     * <p>
     * The segment of input text extracted from which the entity was detected.
     * </p>
     * 
     * @return The segment of input text extracted from which the entity was detected.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The category of the entity. The recognized categories are <code>GENERIC</code> or <code>BRAND_NAME</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link RxNormEntityCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the entity. The recognized categories are <code>GENERIC</code> or <code>BRAND_NAME</code>
     *         .
     * @see RxNormEntityCategory
     */
    public final RxNormEntityCategory category() {
        return RxNormEntityCategory.fromValue(category);
    }

    /**
     * <p>
     * The category of the entity. The recognized categories are <code>GENERIC</code> or <code>BRAND_NAME</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link RxNormEntityCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the entity. The recognized categories are <code>GENERIC</code> or <code>BRAND_NAME</code>
     *         .
     * @see RxNormEntityCategory
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * Describes the specific type of entity. For InferRxNorm, the recognized entity type is <code>MEDICATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RxNormEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Describes the specific type of entity. For InferRxNorm, the recognized entity type is
     *         <code>MEDICATION</code>.
     * @see RxNormEntityType
     */
    public final RxNormEntityType type() {
        return RxNormEntityType.fromValue(type);
    }

    /**
     * <p>
     * Describes the specific type of entity. For InferRxNorm, the recognized entity type is <code>MEDICATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RxNormEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Describes the specific type of entity. For InferRxNorm, the recognized entity type is
     *         <code>MEDICATION</code>.
     * @see RxNormEntityType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The level of confidence that Amazon Comprehend Medical has in the accuracy of the detected entity.
     * </p>
     * 
     * @return The level of confidence that Amazon Comprehend Medical has in the accuracy of the detected entity.
     */
    public final Float score() {
        return score;
    }

    /**
     * <p>
     * The 0-based character offset in the input text that shows where the entity begins. The offset returns the UTF-8
     * code point in the string.
     * </p>
     * 
     * @return The 0-based character offset in the input text that shows where the entity begins. The offset returns the
     *         UTF-8 code point in the string.
     */
    public final Integer beginOffset() {
        return beginOffset;
    }

    /**
     * <p>
     * The 0-based character offset in the input text that shows where the entity ends. The offset returns the UTF-8
     * code point in the string.
     * </p>
     * 
     * @return The 0-based character offset in the input text that shows where the entity ends. The offset returns the
     *         UTF-8 code point in the string.
     */
    public final Integer endOffset() {
        return endOffset;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The extracted attributes that relate to the entity. The attributes recognized by InferRxNorm are
     * <code>DOSAGE</code>, <code>DURATION</code>, <code>FORM</code>, <code>FREQUENCY</code>, <code>RATE</code>,
     * <code>ROUTE_OR_MODE</code>, and <code>STRENGTH</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The extracted attributes that relate to the entity. The attributes recognized by InferRxNorm are
     *         <code>DOSAGE</code>, <code>DURATION</code>, <code>FORM</code>, <code>FREQUENCY</code>, <code>RATE</code>,
     *         <code>ROUTE_OR_MODE</code>, and <code>STRENGTH</code>.
     */
    public final List<RxNormAttribute> attributes() {
        return attributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Traits property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTraits() {
        return traits != null && !(traits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contextual information for the entity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTraits} method.
     * </p>
     * 
     * @return Contextual information for the entity.
     */
    public final List<RxNormTrait> traits() {
        return traits;
    }

    /**
     * For responses, this returns true if the service returned a value for the RxNormConcepts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRxNormConcepts() {
        return rxNormConcepts != null && !(rxNormConcepts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The RxNorm concepts that the entity could refer to, along with a score indicating the likelihood of the match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRxNormConcepts} method.
     * </p>
     * 
     * @return The RxNorm concepts that the entity could refer to, along with a score indicating the likelihood of the
     *         match.
     */
    public final List<RxNormConcept> rxNormConcepts() {
        return rxNormConcepts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTraits() ? traits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRxNormConcepts() ? rxNormConcepts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RxNormEntity)) {
            return false;
        }
        RxNormEntity other = (RxNormEntity) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(text(), other.text())
                && Objects.equals(categoryAsString(), other.categoryAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(score(), other.score())
                && Objects.equals(beginOffset(), other.beginOffset()) && Objects.equals(endOffset(), other.endOffset())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && hasTraits() == other.hasTraits() && Objects.equals(traits(), other.traits())
                && hasRxNormConcepts() == other.hasRxNormConcepts() && Objects.equals(rxNormConcepts(), other.rxNormConcepts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RxNormEntity").add("Id", id()).add("Text", text()).add("Category", categoryAsString())
                .add("Type", typeAsString()).add("Score", score()).add("BeginOffset", beginOffset())
                .add("EndOffset", endOffset()).add("Attributes", hasAttributes() ? attributes() : null)
                .add("Traits", hasTraits() ? traits() : null)
                .add("RxNormConcepts", hasRxNormConcepts() ? rxNormConcepts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "Category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        case "BeginOffset":
            return Optional.ofNullable(clazz.cast(beginOffset()));
        case "EndOffset":
            return Optional.ofNullable(clazz.cast(endOffset()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "Traits":
            return Optional.ofNullable(clazz.cast(traits()));
        case "RxNormConcepts":
            return Optional.ofNullable(clazz.cast(rxNormConcepts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RxNormEntity, T> g) {
        return obj -> g.apply((RxNormEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RxNormEntity> {
        /**
         * <p>
         * The numeric identifier for the entity. This is a monotonically increasing id unique within this response
         * rather than a global unique identifier.
         * </p>
         * 
         * @param id
         *        The numeric identifier for the entity. This is a monotonically increasing id unique within this
         *        response rather than a global unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(Integer id);

        /**
         * <p>
         * The segment of input text extracted from which the entity was detected.
         * </p>
         * 
         * @param text
         *        The segment of input text extracted from which the entity was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The category of the entity. The recognized categories are <code>GENERIC</code> or <code>BRAND_NAME</code>.
         * </p>
         * 
         * @param category
         *        The category of the entity. The recognized categories are <code>GENERIC</code> or
         *        <code>BRAND_NAME</code>.
         * @see RxNormEntityCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RxNormEntityCategory
         */
        Builder category(String category);

        /**
         * <p>
         * The category of the entity. The recognized categories are <code>GENERIC</code> or <code>BRAND_NAME</code>.
         * </p>
         * 
         * @param category
         *        The category of the entity. The recognized categories are <code>GENERIC</code> or
         *        <code>BRAND_NAME</code>.
         * @see RxNormEntityCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RxNormEntityCategory
         */
        Builder category(RxNormEntityCategory category);

        /**
         * <p>
         * Describes the specific type of entity. For InferRxNorm, the recognized entity type is <code>MEDICATION</code>
         * .
         * </p>
         * 
         * @param type
         *        Describes the specific type of entity. For InferRxNorm, the recognized entity type is
         *        <code>MEDICATION</code>.
         * @see RxNormEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RxNormEntityType
         */
        Builder type(String type);

        /**
         * <p>
         * Describes the specific type of entity. For InferRxNorm, the recognized entity type is <code>MEDICATION</code>
         * .
         * </p>
         * 
         * @param type
         *        Describes the specific type of entity. For InferRxNorm, the recognized entity type is
         *        <code>MEDICATION</code>.
         * @see RxNormEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RxNormEntityType
         */
        Builder type(RxNormEntityType type);

        /**
         * <p>
         * The level of confidence that Amazon Comprehend Medical has in the accuracy of the detected entity.
         * </p>
         * 
         * @param score
         *        The level of confidence that Amazon Comprehend Medical has in the accuracy of the detected entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Float score);

        /**
         * <p>
         * The 0-based character offset in the input text that shows where the entity begins. The offset returns the
         * UTF-8 code point in the string.
         * </p>
         * 
         * @param beginOffset
         *        The 0-based character offset in the input text that shows where the entity begins. The offset returns
         *        the UTF-8 code point in the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffset(Integer beginOffset);

        /**
         * <p>
         * The 0-based character offset in the input text that shows where the entity ends. The offset returns the UTF-8
         * code point in the string.
         * </p>
         * 
         * @param endOffset
         *        The 0-based character offset in the input text that shows where the entity ends. The offset returns
         *        the UTF-8 code point in the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffset(Integer endOffset);

        /**
         * <p>
         * The extracted attributes that relate to the entity. The attributes recognized by InferRxNorm are
         * <code>DOSAGE</code>, <code>DURATION</code>, <code>FORM</code>, <code>FREQUENCY</code>, <code>RATE</code>,
         * <code>ROUTE_OR_MODE</code>, and <code>STRENGTH</code>.
         * </p>
         * 
         * @param attributes
         *        The extracted attributes that relate to the entity. The attributes recognized by InferRxNorm are
         *        <code>DOSAGE</code>, <code>DURATION</code>, <code>FORM</code>, <code>FREQUENCY</code>,
         *        <code>RATE</code>, <code>ROUTE_OR_MODE</code>, and <code>STRENGTH</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<RxNormAttribute> attributes);

        /**
         * <p>
         * The extracted attributes that relate to the entity. The attributes recognized by InferRxNorm are
         * <code>DOSAGE</code>, <code>DURATION</code>, <code>FORM</code>, <code>FREQUENCY</code>, <code>RATE</code>,
         * <code>ROUTE_OR_MODE</code>, and <code>STRENGTH</code>.
         * </p>
         * 
         * @param attributes
         *        The extracted attributes that relate to the entity. The attributes recognized by InferRxNorm are
         *        <code>DOSAGE</code>, <code>DURATION</code>, <code>FORM</code>, <code>FREQUENCY</code>,
         *        <code>RATE</code>, <code>ROUTE_OR_MODE</code>, and <code>STRENGTH</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(RxNormAttribute... attributes);

        /**
         * <p>
         * The extracted attributes that relate to the entity. The attributes recognized by InferRxNorm are
         * <code>DOSAGE</code>, <code>DURATION</code>, <code>FORM</code>, <code>FREQUENCY</code>, <code>RATE</code>,
         * <code>ROUTE_OR_MODE</code>, and <code>STRENGTH</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<RxNormAttribute>.Builder} avoiding
         * the need to create one manually via {@link List<RxNormAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RxNormAttribute>.Builder#build()} is called immediately and
         * its result is passed to {@link #attributes(List<RxNormAttribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<RxNormAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<RxNormAttribute>)
         */
        Builder attributes(Consumer<RxNormAttribute.Builder>... attributes);

        /**
         * <p>
         * Contextual information for the entity.
         * </p>
         * 
         * @param traits
         *        Contextual information for the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traits(Collection<RxNormTrait> traits);

        /**
         * <p>
         * Contextual information for the entity.
         * </p>
         * 
         * @param traits
         *        Contextual information for the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traits(RxNormTrait... traits);

        /**
         * <p>
         * Contextual information for the entity.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<RxNormTrait>.Builder} avoiding the
         * need to create one manually via {@link List<RxNormTrait>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RxNormTrait>.Builder#build()} is called immediately and its
         * result is passed to {@link #traits(List<RxNormTrait>)}.
         * 
         * @param traits
         *        a consumer that will call methods on {@link List<RxNormTrait>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traits(List<RxNormTrait>)
         */
        Builder traits(Consumer<RxNormTrait.Builder>... traits);

        /**
         * <p>
         * The RxNorm concepts that the entity could refer to, along with a score indicating the likelihood of the
         * match.
         * </p>
         * 
         * @param rxNormConcepts
         *        The RxNorm concepts that the entity could refer to, along with a score indicating the likelihood of
         *        the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rxNormConcepts(Collection<RxNormConcept> rxNormConcepts);

        /**
         * <p>
         * The RxNorm concepts that the entity could refer to, along with a score indicating the likelihood of the
         * match.
         * </p>
         * 
         * @param rxNormConcepts
         *        The RxNorm concepts that the entity could refer to, along with a score indicating the likelihood of
         *        the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rxNormConcepts(RxNormConcept... rxNormConcepts);

        /**
         * <p>
         * The RxNorm concepts that the entity could refer to, along with a score indicating the likelihood of the
         * match.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<RxNormConcept>.Builder} avoiding the
         * need to create one manually via {@link List<RxNormConcept>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RxNormConcept>.Builder#build()} is called immediately and
         * its result is passed to {@link #rxNormConcepts(List<RxNormConcept>)}.
         * 
         * @param rxNormConcepts
         *        a consumer that will call methods on {@link List<RxNormConcept>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rxNormConcepts(List<RxNormConcept>)
         */
        Builder rxNormConcepts(Consumer<RxNormConcept.Builder>... rxNormConcepts);
    }

    static final class BuilderImpl implements Builder {
        private Integer id;

        private String text;

        private String category;

        private String type;

        private Float score;

        private Integer beginOffset;

        private Integer endOffset;

        private List<RxNormAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private List<RxNormTrait> traits = DefaultSdkAutoConstructList.getInstance();

        private List<RxNormConcept> rxNormConcepts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RxNormEntity model) {
            id(model.id);
            text(model.text);
            category(model.category);
            type(model.type);
            score(model.score);
            beginOffset(model.beginOffset);
            endOffset(model.endOffset);
            attributes(model.attributes);
            traits(model.traits);
            rxNormConcepts(model.rxNormConcepts);
        }

        public final Integer getId() {
            return id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        @Transient
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        @Transient
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        @Transient
        public final Builder category(RxNormEntityCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(RxNormEntityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Float getScore() {
            return score;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        @Transient
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final Integer getBeginOffset() {
            return beginOffset;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        @Transient
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final Integer getEndOffset() {
            return endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        @Transient
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final List<RxNormAttribute.Builder> getAttributes() {
            List<RxNormAttribute.Builder> result = RxNormAttributeListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<RxNormAttribute.BuilderImpl> attributes) {
            this.attributes = RxNormAttributeListCopier.copyFromBuilder(attributes);
        }

        @Override
        @Transient
        public final Builder attributes(Collection<RxNormAttribute> attributes) {
            this.attributes = RxNormAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributes(RxNormAttribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributes(Consumer<RxNormAttribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> RxNormAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RxNormTrait.Builder> getTraits() {
            List<RxNormTrait.Builder> result = RxNormTraitListCopier.copyToBuilder(this.traits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTraits(Collection<RxNormTrait.BuilderImpl> traits) {
            this.traits = RxNormTraitListCopier.copyFromBuilder(traits);
        }

        @Override
        @Transient
        public final Builder traits(Collection<RxNormTrait> traits) {
            this.traits = RxNormTraitListCopier.copy(traits);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder traits(RxNormTrait... traits) {
            traits(Arrays.asList(traits));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder traits(Consumer<RxNormTrait.Builder>... traits) {
            traits(Stream.of(traits).map(c -> RxNormTrait.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RxNormConcept.Builder> getRxNormConcepts() {
            List<RxNormConcept.Builder> result = RxNormConceptListCopier.copyToBuilder(this.rxNormConcepts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRxNormConcepts(Collection<RxNormConcept.BuilderImpl> rxNormConcepts) {
            this.rxNormConcepts = RxNormConceptListCopier.copyFromBuilder(rxNormConcepts);
        }

        @Override
        @Transient
        public final Builder rxNormConcepts(Collection<RxNormConcept> rxNormConcepts) {
            this.rxNormConcepts = RxNormConceptListCopier.copy(rxNormConcepts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rxNormConcepts(RxNormConcept... rxNormConcepts) {
            rxNormConcepts(Arrays.asList(rxNormConcepts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rxNormConcepts(Consumer<RxNormConcept.Builder>... rxNormConcepts) {
            rxNormConcepts(Stream.of(rxNormConcepts).map(c -> RxNormConcept.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RxNormEntity build() {
            return new RxNormEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
