/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The extracted attributes that relate to this entity. The attributes recognized by InferRxNorm are <code>DOSAGE</code>, <code>DURATION</code>, <code>FORM</code>, <code>FREQUENCY</code>, <code>RATE</code>, <code>ROUTE_OR_MODE</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RxNormAttribute implements SdkPojo, Serializable, ToCopyableBuilder<RxNormAttribute.Builder, RxNormAttribute> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RxNormAttribute::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Float> SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Score")
            .getter(getter(RxNormAttribute::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final SdkField<Float> RELATIONSHIP_SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("RelationshipScore").getter(getter(RxNormAttribute::relationshipScore))
            .setter(setter(Builder::relationshipScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelationshipScore").build()).build();

    private static final SdkField<Integer> ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Id")
            .getter(getter(RxNormAttribute::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BeginOffset").getter(getter(RxNormAttribute::beginOffset)).setter(setter(Builder::beginOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()).build();

    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndOffset").getter(getter(RxNormAttribute::endOffset)).setter(setter(Builder::endOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(RxNormAttribute::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<List<RxNormTrait>> TRAITS_FIELD = SdkField
            .<List<RxNormTrait>> builder(MarshallingType.LIST)
            .memberName("Traits")
            .getter(getter(RxNormAttribute::traits))
            .setter(setter(Builder::traits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RxNormTrait> builder(MarshallingType.SDK_POJO)
                                            .constructor(RxNormTrait::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, SCORE_FIELD,
            RELATIONSHIP_SCORE_FIELD, ID_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, TEXT_FIELD, TRAITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Float score;

    private final Float relationshipScore;

    private final Integer id;

    private final Integer beginOffset;

    private final Integer endOffset;

    private final String text;

    private final List<RxNormTrait> traits;

    private RxNormAttribute(BuilderImpl builder) {
        this.type = builder.type;
        this.score = builder.score;
        this.relationshipScore = builder.relationshipScore;
        this.id = builder.id;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.text = builder.text;
        this.traits = builder.traits;
    }

    /**
     * <p>
     * The type of attribute. The types of attributes recognized by InferRxNorm are <code>BRAND_NAME</code> and
     * <code>GENERIC_NAME</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RxNormAttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of attribute. The types of attributes recognized by InferRxNorm are <code>BRAND_NAME</code> and
     *         <code>GENERIC_NAME</code>.
     * @see RxNormAttributeType
     */
    public final RxNormAttributeType type() {
        return RxNormAttributeType.fromValue(type);
    }

    /**
     * <p>
     * The type of attribute. The types of attributes recognized by InferRxNorm are <code>BRAND_NAME</code> and
     * <code>GENERIC_NAME</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RxNormAttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of attribute. The types of attributes recognized by InferRxNorm are <code>BRAND_NAME</code> and
     *         <code>GENERIC_NAME</code>.
     * @see RxNormAttributeType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The level of confidence that Comprehend Medical has that the segment of text is correctly recognized as an
     * attribute.
     * </p>
     * 
     * @return The level of confidence that Comprehend Medical has that the segment of text is correctly recognized as
     *         an attribute.
     */
    public final Float score() {
        return score;
    }

    /**
     * <p>
     * The level of confidence that Amazon Comprehend Medical has that the attribute is accurately linked to an entity.
     * </p>
     * 
     * @return The level of confidence that Amazon Comprehend Medical has that the attribute is accurately linked to an
     *         entity.
     */
    public final Float relationshipScore() {
        return relationshipScore;
    }

    /**
     * <p>
     * The numeric identifier for this attribute. This is a monotonically increasing id unique within this response
     * rather than a global unique identifier.
     * </p>
     * 
     * @return The numeric identifier for this attribute. This is a monotonically increasing id unique within this
     *         response rather than a global unique identifier.
     */
    public final Integer id() {
        return id;
    }

    /**
     * <p>
     * The 0-based character offset in the input text that shows where the attribute begins. The offset returns the
     * UTF-8 code point in the string.
     * </p>
     * 
     * @return The 0-based character offset in the input text that shows where the attribute begins. The offset returns
     *         the UTF-8 code point in the string.
     */
    public final Integer beginOffset() {
        return beginOffset;
    }

    /**
     * <p>
     * The 0-based character offset in the input text that shows where the attribute ends. The offset returns the UTF-8
     * code point in the string.
     * </p>
     * 
     * @return The 0-based character offset in the input text that shows where the attribute ends. The offset returns
     *         the UTF-8 code point in the string.
     */
    public final Integer endOffset() {
        return endOffset;
    }

    /**
     * <p>
     * The segment of input text which corresponds to the detected attribute.
     * </p>
     * 
     * @return The segment of input text which corresponds to the detected attribute.
     */
    public final String text() {
        return text;
    }

    /**
     * For responses, this returns true if the service returned a value for the Traits property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTraits() {
        return traits != null && !(traits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contextual information for the attribute. InferRxNorm recognizes the trait <code>NEGATION</code> for attributes,
     * i.e. that the patient is not taking a specific dose or form of a medication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTraits} method.
     * </p>
     * 
     * @return Contextual information for the attribute. InferRxNorm recognizes the trait <code>NEGATION</code> for
     *         attributes, i.e. that the patient is not taking a specific dose or form of a medication.
     */
    public final List<RxNormTrait> traits() {
        return traits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(relationshipScore());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(hasTraits() ? traits() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RxNormAttribute)) {
            return false;
        }
        RxNormAttribute other = (RxNormAttribute) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(score(), other.score())
                && Objects.equals(relationshipScore(), other.relationshipScore()) && Objects.equals(id(), other.id())
                && Objects.equals(beginOffset(), other.beginOffset()) && Objects.equals(endOffset(), other.endOffset())
                && Objects.equals(text(), other.text()) && hasTraits() == other.hasTraits()
                && Objects.equals(traits(), other.traits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RxNormAttribute").add("Type", typeAsString()).add("Score", score())
                .add("RelationshipScore", relationshipScore()).add("Id", id()).add("BeginOffset", beginOffset())
                .add("EndOffset", endOffset()).add("Text", text()).add("Traits", hasTraits() ? traits() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        case "RelationshipScore":
            return Optional.ofNullable(clazz.cast(relationshipScore()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "BeginOffset":
            return Optional.ofNullable(clazz.cast(beginOffset()));
        case "EndOffset":
            return Optional.ofNullable(clazz.cast(endOffset()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "Traits":
            return Optional.ofNullable(clazz.cast(traits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RxNormAttribute, T> g) {
        return obj -> g.apply((RxNormAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RxNormAttribute> {
        /**
         * <p>
         * The type of attribute. The types of attributes recognized by InferRxNorm are <code>BRAND_NAME</code> and
         * <code>GENERIC_NAME</code>.
         * </p>
         * 
         * @param type
         *        The type of attribute. The types of attributes recognized by InferRxNorm are <code>BRAND_NAME</code>
         *        and <code>GENERIC_NAME</code>.
         * @see RxNormAttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RxNormAttributeType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of attribute. The types of attributes recognized by InferRxNorm are <code>BRAND_NAME</code> and
         * <code>GENERIC_NAME</code>.
         * </p>
         * 
         * @param type
         *        The type of attribute. The types of attributes recognized by InferRxNorm are <code>BRAND_NAME</code>
         *        and <code>GENERIC_NAME</code>.
         * @see RxNormAttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RxNormAttributeType
         */
        Builder type(RxNormAttributeType type);

        /**
         * <p>
         * The level of confidence that Comprehend Medical has that the segment of text is correctly recognized as an
         * attribute.
         * </p>
         * 
         * @param score
         *        The level of confidence that Comprehend Medical has that the segment of text is correctly recognized
         *        as an attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Float score);

        /**
         * <p>
         * The level of confidence that Amazon Comprehend Medical has that the attribute is accurately linked to an
         * entity.
         * </p>
         * 
         * @param relationshipScore
         *        The level of confidence that Amazon Comprehend Medical has that the attribute is accurately linked to
         *        an entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationshipScore(Float relationshipScore);

        /**
         * <p>
         * The numeric identifier for this attribute. This is a monotonically increasing id unique within this response
         * rather than a global unique identifier.
         * </p>
         * 
         * @param id
         *        The numeric identifier for this attribute. This is a monotonically increasing id unique within this
         *        response rather than a global unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(Integer id);

        /**
         * <p>
         * The 0-based character offset in the input text that shows where the attribute begins. The offset returns the
         * UTF-8 code point in the string.
         * </p>
         * 
         * @param beginOffset
         *        The 0-based character offset in the input text that shows where the attribute begins. The offset
         *        returns the UTF-8 code point in the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffset(Integer beginOffset);

        /**
         * <p>
         * The 0-based character offset in the input text that shows where the attribute ends. The offset returns the
         * UTF-8 code point in the string.
         * </p>
         * 
         * @param endOffset
         *        The 0-based character offset in the input text that shows where the attribute ends. The offset returns
         *        the UTF-8 code point in the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffset(Integer endOffset);

        /**
         * <p>
         * The segment of input text which corresponds to the detected attribute.
         * </p>
         * 
         * @param text
         *        The segment of input text which corresponds to the detected attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * Contextual information for the attribute. InferRxNorm recognizes the trait <code>NEGATION</code> for
         * attributes, i.e. that the patient is not taking a specific dose or form of a medication.
         * </p>
         * 
         * @param traits
         *        Contextual information for the attribute. InferRxNorm recognizes the trait <code>NEGATION</code> for
         *        attributes, i.e. that the patient is not taking a specific dose or form of a medication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traits(Collection<RxNormTrait> traits);

        /**
         * <p>
         * Contextual information for the attribute. InferRxNorm recognizes the trait <code>NEGATION</code> for
         * attributes, i.e. that the patient is not taking a specific dose or form of a medication.
         * </p>
         * 
         * @param traits
         *        Contextual information for the attribute. InferRxNorm recognizes the trait <code>NEGATION</code> for
         *        attributes, i.e. that the patient is not taking a specific dose or form of a medication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traits(RxNormTrait... traits);

        /**
         * <p>
         * Contextual information for the attribute. InferRxNorm recognizes the trait <code>NEGATION</code> for
         * attributes, i.e. that the patient is not taking a specific dose or form of a medication.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<RxNormTrait>.Builder} avoiding the
         * need to create one manually via {@link List<RxNormTrait>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RxNormTrait>.Builder#build()} is called immediately and its
         * result is passed to {@link #traits(List<RxNormTrait>)}.
         * 
         * @param traits
         *        a consumer that will call methods on {@link List<RxNormTrait>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traits(List<RxNormTrait>)
         */
        Builder traits(Consumer<RxNormTrait.Builder>... traits);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Float score;

        private Float relationshipScore;

        private Integer id;

        private Integer beginOffset;

        private Integer endOffset;

        private String text;

        private List<RxNormTrait> traits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RxNormAttribute model) {
            type(model.type);
            score(model.score);
            relationshipScore(model.relationshipScore);
            id(model.id);
            beginOffset(model.beginOffset);
            endOffset(model.endOffset);
            text(model.text);
            traits(model.traits);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(RxNormAttributeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Float getScore() {
            return score;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        @Transient
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final Float getRelationshipScore() {
            return relationshipScore;
        }

        public final void setRelationshipScore(Float relationshipScore) {
            this.relationshipScore = relationshipScore;
        }

        @Override
        @Transient
        public final Builder relationshipScore(Float relationshipScore) {
            this.relationshipScore = relationshipScore;
            return this;
        }

        public final Integer getId() {
            return id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final Integer getBeginOffset() {
            return beginOffset;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        @Transient
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final Integer getEndOffset() {
            return endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        @Transient
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        @Transient
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final List<RxNormTrait.Builder> getTraits() {
            List<RxNormTrait.Builder> result = RxNormTraitListCopier.copyToBuilder(this.traits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTraits(Collection<RxNormTrait.BuilderImpl> traits) {
            this.traits = RxNormTraitListCopier.copyFromBuilder(traits);
        }

        @Override
        @Transient
        public final Builder traits(Collection<RxNormTrait> traits) {
            this.traits = RxNormTraitListCopier.copy(traits);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder traits(RxNormTrait... traits) {
            traits(Arrays.asList(traits));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder traits(Consumer<RxNormTrait.Builder>... traits) {
            traits(Stream.of(traits).map(c -> RxNormTrait.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RxNormAttribute build() {
            return new RxNormAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
