/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferIcd10CmResponse extends ComprehendMedicalResponse implements
        ToCopyableBuilder<InferIcd10CmResponse.Builder, InferIcd10CmResponse> {
    private static final SdkField<List<ICD10CMEntity>> ENTITIES_FIELD = SdkField
            .<List<ICD10CMEntity>> builder(MarshallingType.LIST)
            .memberName("Entities")
            .getter(getter(InferIcd10CmResponse::entities))
            .setter(setter(Builder::entities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ICD10CMEntity> builder(MarshallingType.SDK_POJO)
                                            .constructor(ICD10CMEntity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaginationToken").getter(getter(InferIcd10CmResponse::paginationToken))
            .setter(setter(Builder::paginationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()).build();

    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersion").getter(getter(InferIcd10CmResponse::modelVersion)).setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD,
            PAGINATION_TOKEN_FIELD, MODEL_VERSION_FIELD));

    private final List<ICD10CMEntity> entities;

    private final String paginationToken;

    private final String modelVersion;

    private InferIcd10CmResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.paginationToken = builder.paginationToken;
        this.modelVersion = builder.modelVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntities() {
        return entities != null && !(entities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The medical conditions detected in the text linked to ICD-10-CM concepts. If the action is successful, the
     * service sends back an HTTP 200 response, as well as the entities detected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntities} method.
     * </p>
     * 
     * @return The medical conditions detected in the text linked to ICD-10-CM concepts. If the action is successful,
     *         the service sends back an HTTP 200 response, as well as the entities detected.
     */
    public final List<ICD10CMEntity> entities() {
        return entities;
    }

    /**
     * <p>
     * If the result of the previous request to <code>InferICD10CM</code> was truncated, include the
     * <code>PaginationToken</code> to fetch the next page of medical condition entities.
     * </p>
     * 
     * @return If the result of the previous request to <code>InferICD10CM</code> was truncated, include the
     *         <code>PaginationToken</code> to fetch the next page of medical condition entities.
     */
    public final String paginationToken() {
        return paginationToken;
    }

    /**
     * <p>
     * The version of the model used to analyze the documents, in the format <i>n</i>.<i>n</i>.<i>n</i> You can use this
     * information to track the model used for a particular batch of documents.
     * </p>
     * 
     * @return The version of the model used to analyze the documents, in the format <i>n</i>.<i>n</i>.<i>n</i> You can
     *         use this information to track the model used for a particular batch of documents.
     */
    public final String modelVersion() {
        return modelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntities() ? entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(paginationToken());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferIcd10CmResponse)) {
            return false;
        }
        InferIcd10CmResponse other = (InferIcd10CmResponse) obj;
        return hasEntities() == other.hasEntities() && Objects.equals(entities(), other.entities())
                && Objects.equals(paginationToken(), other.paginationToken())
                && Objects.equals(modelVersion(), other.modelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferIcd10CmResponse").add("Entities", hasEntities() ? entities() : null)
                .add("PaginationToken", paginationToken()).add("ModelVersion", modelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entities":
            return Optional.ofNullable(clazz.cast(entities()));
        case "PaginationToken":
            return Optional.ofNullable(clazz.cast(paginationToken()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferIcd10CmResponse, T> g) {
        return obj -> g.apply((InferIcd10CmResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendMedicalResponse.Builder, SdkPojo, CopyableBuilder<Builder, InferIcd10CmResponse> {
        /**
         * <p>
         * The medical conditions detected in the text linked to ICD-10-CM concepts. If the action is successful, the
         * service sends back an HTTP 200 response, as well as the entities detected.
         * </p>
         * 
         * @param entities
         *        The medical conditions detected in the text linked to ICD-10-CM concepts. If the action is successful,
         *        the service sends back an HTTP 200 response, as well as the entities detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Collection<ICD10CMEntity> entities);

        /**
         * <p>
         * The medical conditions detected in the text linked to ICD-10-CM concepts. If the action is successful, the
         * service sends back an HTTP 200 response, as well as the entities detected.
         * </p>
         * 
         * @param entities
         *        The medical conditions detected in the text linked to ICD-10-CM concepts. If the action is successful,
         *        the service sends back an HTTP 200 response, as well as the entities detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(ICD10CMEntity... entities);

        /**
         * <p>
         * The medical conditions detected in the text linked to ICD-10-CM concepts. If the action is successful, the
         * service sends back an HTTP 200 response, as well as the entities detected.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ICD10CMEntity>.Builder} avoiding the
         * need to create one manually via {@link List<ICD10CMEntity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ICD10CMEntity>.Builder#build()} is called immediately and
         * its result is passed to {@link #entities(List<ICD10CMEntity>)}.
         * 
         * @param entities
         *        a consumer that will call methods on {@link List<ICD10CMEntity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(List<ICD10CMEntity>)
         */
        Builder entities(Consumer<ICD10CMEntity.Builder>... entities);

        /**
         * <p>
         * If the result of the previous request to <code>InferICD10CM</code> was truncated, include the
         * <code>PaginationToken</code> to fetch the next page of medical condition entities.
         * </p>
         * 
         * @param paginationToken
         *        If the result of the previous request to <code>InferICD10CM</code> was truncated, include the
         *        <code>PaginationToken</code> to fetch the next page of medical condition entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginationToken(String paginationToken);

        /**
         * <p>
         * The version of the model used to analyze the documents, in the format <i>n</i>.<i>n</i>.<i>n</i> You can use
         * this information to track the model used for a particular batch of documents.
         * </p>
         * 
         * @param modelVersion
         *        The version of the model used to analyze the documents, in the format <i>n</i>.<i>n</i>.<i>n</i> You
         *        can use this information to track the model used for a particular batch of documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);
    }

    static final class BuilderImpl extends ComprehendMedicalResponse.BuilderImpl implements Builder {
        private List<ICD10CMEntity> entities = DefaultSdkAutoConstructList.getInstance();

        private String paginationToken;

        private String modelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(InferIcd10CmResponse model) {
            super(model);
            entities(model.entities);
            paginationToken(model.paginationToken);
            modelVersion(model.modelVersion);
        }

        public final List<ICD10CMEntity.Builder> getEntities() {
            List<ICD10CMEntity.Builder> result = ICD10CMEntityListCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<ICD10CMEntity.BuilderImpl> entities) {
            this.entities = ICD10CMEntityListCopier.copyFromBuilder(entities);
        }

        @Override
        @Transient
        public final Builder entities(Collection<ICD10CMEntity> entities) {
            this.entities = ICD10CMEntityListCopier.copy(entities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entities(ICD10CMEntity... entities) {
            entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entities(Consumer<ICD10CMEntity.Builder>... entities) {
            entities(Stream.of(entities).map(c -> ICD10CMEntity.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPaginationToken() {
            return paginationToken;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        @Transient
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        @Transient
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        @Override
        public InferIcd10CmResponse build() {
            return new InferIcd10CmResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
