/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehendmedical.model.Attribute;
import software.amazon.awssdk.services.comprehendmedical.model.AttributeListCopier;
import software.amazon.awssdk.services.comprehendmedical.model.EntitySubType;
import software.amazon.awssdk.services.comprehendmedical.model.EntityType;
import software.amazon.awssdk.services.comprehendmedical.model.Trait;
import software.amazon.awssdk.services.comprehendmedical.model.TraitListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Entity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Entity> {
    private static final SdkField<Integer> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Id").getter(Entity.getter(Entity::id)).setter(Entity.setter(Builder::id)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BeginOffset").getter(Entity.getter(Entity::beginOffset)).setter(Entity.setter(Builder::beginOffset)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()}).build();
    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndOffset").getter(Entity.getter(Entity::endOffset)).setter(Entity.setter(Builder::endOffset)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()}).build();
    private static final SdkField<Float> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Score").getter(Entity.getter(Entity::score)).setter(Entity.setter(Builder::score)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(Entity.getter(Entity::text)).setter(Entity.setter(Builder::text)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(Entity.getter(Entity::categoryAsString)).setter(Entity.setter(Builder::category)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Entity.getter(Entity::typeAsString)).setter(Entity.setter(Builder::type)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<Trait>> TRAITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Traits").getter(Entity.getter(Entity::traits)).setter(Entity.setter(Builder::traits)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Trait::builder).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attributes").getter(Entity.getter(Entity::attributes)).setter(Entity.setter(Builder::attributes)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, SCORE_FIELD, TEXT_FIELD, CATEGORY_FIELD, TYPE_FIELD, TRAITS_FIELD, ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer id;
    private final Integer beginOffset;
    private final Integer endOffset;
    private final Float score;
    private final String text;
    private final String category;
    private final String type;
    private final List<Trait> traits;
    private final List<Attribute> attributes;

    private Entity(BuilderImpl builder) {
        this.id = builder.id;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.score = builder.score;
        this.text = builder.text;
        this.category = builder.category;
        this.type = builder.type;
        this.traits = builder.traits;
        this.attributes = builder.attributes;
    }

    public final Integer id() {
        return this.id;
    }

    public final Integer beginOffset() {
        return this.beginOffset;
    }

    public final Integer endOffset() {
        return this.endOffset;
    }

    public final Float score() {
        return this.score;
    }

    public final String text() {
        return this.text;
    }

    public final EntityType category() {
        return EntityType.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final EntitySubType type() {
        return EntitySubType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasTraits() {
        return this.traits != null && !(this.traits instanceof SdkAutoConstructList);
    }

    public final List<Trait> traits() {
        return this.traits;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<Attribute> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTraits() ? this.traits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.beginOffset(), other.beginOffset()) && Objects.equals(this.endOffset(), other.endOffset()) && Objects.equals(this.score(), other.score()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasTraits() == other.hasTraits() && Objects.equals(this.traits(), other.traits()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"Entity").add("Id", (Object)this.id()).add("BeginOffset", (Object)this.beginOffset()).add("EndOffset", (Object)this.endOffset()).add("Score", (Object)this.score()).add("Text", (Object)this.text()).add("Category", (Object)this.categoryAsString()).add("Type", (Object)this.typeAsString()).add("Traits", this.hasTraits() ? this.traits() : null).add("Attributes", this.hasAttributes() ? this.attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "BeginOffset": {
                return Optional.ofNullable(clazz.cast(this.beginOffset()));
            }
            case "EndOffset": {
                return Optional.ofNullable(clazz.cast(this.endOffset()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Traits": {
                return Optional.ofNullable(clazz.cast(this.traits()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Entity, T> g) {
        return obj -> g.apply((Entity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer id;
        private Integer beginOffset;
        private Integer endOffset;
        private Float score;
        private String text;
        private String category;
        private String type;
        private List<Trait> traits = DefaultSdkAutoConstructList.getInstance();
        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Entity model) {
            this.id(model.id);
            this.beginOffset(model.beginOffset);
            this.endOffset(model.endOffset);
            this.score(model.score);
            this.text(model.text);
            this.category(model.category);
            this.type(model.type);
            this.traits(model.traits);
            this.attributes(model.attributes);
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final Integer getBeginOffset() {
            return this.beginOffset;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        @Transient
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final Integer getEndOffset() {
            return this.endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        @Transient
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final Float getScore() {
            return this.score;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        @Transient
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        @Transient
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        @Transient
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        @Transient
        public final Builder category(EntityType category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(EntitySubType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<Trait.Builder> getTraits() {
            List<Trait.Builder> result = TraitListCopier.copyToBuilder(this.traits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTraits(Collection<Trait.BuilderImpl> traits) {
            this.traits = TraitListCopier.copyFromBuilder(traits);
        }

        @Override
        @Transient
        public final Builder traits(Collection<Trait> traits) {
            this.traits = TraitListCopier.copy(traits);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder traits(Trait ... traits) {
            this.traits(Arrays.asList(traits));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder traits(Consumer<Trait.Builder> ... traits) {
            this.traits(Stream.of(traits).map(c -> (Trait)((Trait.Builder)Trait.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Attribute.Builder> getAttributes() {
            List<Attribute.Builder> result = AttributeListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = AttributeListCopier.copyFromBuilder(attributes);
        }

        @Override
        @Transient
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributes(Attribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Entity build() {
            return new Entity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Entity> {
        public Builder id(Integer var1);

        public Builder beginOffset(Integer var1);

        public Builder endOffset(Integer var1);

        public Builder score(Float var1);

        public Builder text(String var1);

        public Builder category(String var1);

        public Builder category(EntityType var1);

        public Builder type(String var1);

        public Builder type(EntitySubType var1);

        public Builder traits(Collection<Trait> var1);

        public Builder traits(Trait ... var1);

        public Builder traits(Consumer<Trait.Builder> ... var1);

        public Builder attributes(Collection<Attribute> var1);

        public Builder attributes(Attribute ... var1);

        public Builder attributes(Consumer<Attribute.Builder> ... var1);
    }
}

