/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The collection of medical entities extracted from the input text and their associated information. For each entity,
 * the response provides the entity text, the entity category, where the entity text begins and ends, and the level of
 * confidence that Amazon Comprehend Medical has in the detection and analysis. Attributes and traits of the entity are
 * also returned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ICD10CMEntity implements SdkPojo, Serializable, ToCopyableBuilder<ICD10CMEntity.Builder, ICD10CMEntity> {
    private static final SdkField<Integer> ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Id")
            .getter(getter(ICD10CMEntity::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(ICD10CMEntity::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(ICD10CMEntity::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ICD10CMEntity::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Float> SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Score")
            .getter(getter(ICD10CMEntity::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BeginOffset").getter(getter(ICD10CMEntity::beginOffset)).setter(setter(Builder::beginOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()).build();

    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndOffset").getter(getter(ICD10CMEntity::endOffset)).setter(setter(Builder::endOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()).build();

    private static final SdkField<List<ICD10CMAttribute>> ATTRIBUTES_FIELD = SdkField
            .<List<ICD10CMAttribute>> builder(MarshallingType.LIST)
            .memberName("Attributes")
            .getter(getter(ICD10CMEntity::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ICD10CMAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(ICD10CMAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ICD10CMTrait>> TRAITS_FIELD = SdkField
            .<List<ICD10CMTrait>> builder(MarshallingType.LIST)
            .memberName("Traits")
            .getter(getter(ICD10CMEntity::traits))
            .setter(setter(Builder::traits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ICD10CMTrait> builder(MarshallingType.SDK_POJO)
                                            .constructor(ICD10CMTrait::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ICD10CMConcept>> ICD10_CM_CONCEPTS_FIELD = SdkField
            .<List<ICD10CMConcept>> builder(MarshallingType.LIST)
            .memberName("ICD10CMConcepts")
            .getter(getter(ICD10CMEntity::icd10CMConcepts))
            .setter(setter(Builder::icd10CMConcepts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ICD10CMConcepts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ICD10CMConcept> builder(MarshallingType.SDK_POJO)
                                            .constructor(ICD10CMConcept::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TEXT_FIELD,
            CATEGORY_FIELD, TYPE_FIELD, SCORE_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, ATTRIBUTES_FIELD, TRAITS_FIELD,
            ICD10_CM_CONCEPTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer id;

    private final String text;

    private final String category;

    private final String type;

    private final Float score;

    private final Integer beginOffset;

    private final Integer endOffset;

    private final List<ICD10CMAttribute> attributes;

    private final List<ICD10CMTrait> traits;

    private final List<ICD10CMConcept> icd10CMConcepts;

    private ICD10CMEntity(BuilderImpl builder) {
        this.id = builder.id;
        this.text = builder.text;
        this.category = builder.category;
        this.type = builder.type;
        this.score = builder.score;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.attributes = builder.attributes;
        this.traits = builder.traits;
        this.icd10CMConcepts = builder.icd10CMConcepts;
    }

    /**
     * <p>
     * The numeric identifier for the entity. This is a monotonically increasing id unique within this response rather
     * than a global unique identifier.
     * </p>
     * 
     * @return The numeric identifier for the entity. This is a monotonically increasing id unique within this response
     *         rather than a global unique identifier.
     */
    public final Integer id() {
        return id;
    }

    /**
     * <p>
     * The segment of input text that is matched to the detected entity.
     * </p>
     * 
     * @return The segment of input text that is matched to the detected entity.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The category of the entity. InferICD10CM detects entities in the <code>MEDICAL_CONDITION</code> category.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link ICD10CMEntityCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the entity. InferICD10CM detects entities in the <code>MEDICAL_CONDITION</code> category.
     * @see ICD10CMEntityCategory
     */
    public final ICD10CMEntityCategory category() {
        return ICD10CMEntityCategory.fromValue(category);
    }

    /**
     * <p>
     * The category of the entity. InferICD10CM detects entities in the <code>MEDICAL_CONDITION</code> category.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link ICD10CMEntityCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the entity. InferICD10CM detects entities in the <code>MEDICAL_CONDITION</code> category.
     * @see ICD10CMEntityCategory
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * Describes the specific type of entity with category of entities. InferICD10CM detects entities of the type
     * <code>DX_NAME</code> and <code>TIME_EXPRESSION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ICD10CMEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Describes the specific type of entity with category of entities. InferICD10CM detects entities of the
     *         type <code>DX_NAME</code> and <code>TIME_EXPRESSION</code>.
     * @see ICD10CMEntityType
     */
    public final ICD10CMEntityType type() {
        return ICD10CMEntityType.fromValue(type);
    }

    /**
     * <p>
     * Describes the specific type of entity with category of entities. InferICD10CM detects entities of the type
     * <code>DX_NAME</code> and <code>TIME_EXPRESSION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ICD10CMEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Describes the specific type of entity with category of entities. InferICD10CM detects entities of the
     *         type <code>DX_NAME</code> and <code>TIME_EXPRESSION</code>.
     * @see ICD10CMEntityType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The level of confidence that Amazon Comprehend Medical has in the accuracy of the detection.
     * </p>
     * 
     * @return The level of confidence that Amazon Comprehend Medical has in the accuracy of the detection.
     */
    public final Float score() {
        return score;
    }

    /**
     * <p>
     * The 0-based character offset in the input text that shows where the entity begins. The offset returns the UTF-8
     * code point in the string.
     * </p>
     * 
     * @return The 0-based character offset in the input text that shows where the entity begins. The offset returns the
     *         UTF-8 code point in the string.
     */
    public final Integer beginOffset() {
        return beginOffset;
    }

    /**
     * <p>
     * The 0-based character offset in the input text that shows where the entity ends. The offset returns the UTF-8
     * code point in the string.
     * </p>
     * 
     * @return The 0-based character offset in the input text that shows where the entity ends. The offset returns the
     *         UTF-8 code point in the string.
     */
    public final Integer endOffset() {
        return endOffset;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The detected attributes that relate to the entity. An extracted segment of the text that is an attribute of an
     * entity, or otherwise related to an entity, such as the nature of a medical condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The detected attributes that relate to the entity. An extracted segment of the text that is an attribute
     *         of an entity, or otherwise related to an entity, such as the nature of a medical condition.
     */
    public final List<ICD10CMAttribute> attributes() {
        return attributes;
    }

    /**
     * Returns true if the Traits property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTraits() {
        return traits != null && !(traits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides Contextual information for the entity. The traits recognized by InferICD10CM are <code>DIAGNOSIS</code>,
     * <code>SIGN</code>, <code>SYMPTOM</code>, and <code>NEGATION.</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTraits()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provides Contextual information for the entity. The traits recognized by InferICD10CM are
     *         <code>DIAGNOSIS</code>, <code>SIGN</code>, <code>SYMPTOM</code>, and <code>NEGATION.</code>
     */
    public final List<ICD10CMTrait> traits() {
        return traits;
    }

    /**
     * Returns true if the ICD10CMConcepts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasIcd10CMConcepts() {
        return icd10CMConcepts != null && !(icd10CMConcepts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ICD-10-CM concepts that the entity could refer to, along with a score indicating the likelihood of the match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIcd10CMConcepts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ICD-10-CM concepts that the entity could refer to, along with a score indicating the likelihood of
     *         the match.
     */
    public final List<ICD10CMConcept> icd10CMConcepts() {
        return icd10CMConcepts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTraits() ? traits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIcd10CMConcepts() ? icd10CMConcepts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ICD10CMEntity)) {
            return false;
        }
        ICD10CMEntity other = (ICD10CMEntity) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(text(), other.text())
                && Objects.equals(categoryAsString(), other.categoryAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(score(), other.score())
                && Objects.equals(beginOffset(), other.beginOffset()) && Objects.equals(endOffset(), other.endOffset())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && hasTraits() == other.hasTraits() && Objects.equals(traits(), other.traits())
                && hasIcd10CMConcepts() == other.hasIcd10CMConcepts()
                && Objects.equals(icd10CMConcepts(), other.icd10CMConcepts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ICD10CMEntity").add("Id", id()).add("Text", text()).add("Category", categoryAsString())
                .add("Type", typeAsString()).add("Score", score()).add("BeginOffset", beginOffset())
                .add("EndOffset", endOffset()).add("Attributes", hasAttributes() ? attributes() : null)
                .add("Traits", hasTraits() ? traits() : null)
                .add("ICD10CMConcepts", hasIcd10CMConcepts() ? icd10CMConcepts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "Category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        case "BeginOffset":
            return Optional.ofNullable(clazz.cast(beginOffset()));
        case "EndOffset":
            return Optional.ofNullable(clazz.cast(endOffset()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "Traits":
            return Optional.ofNullable(clazz.cast(traits()));
        case "ICD10CMConcepts":
            return Optional.ofNullable(clazz.cast(icd10CMConcepts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ICD10CMEntity, T> g) {
        return obj -> g.apply((ICD10CMEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ICD10CMEntity> {
        /**
         * <p>
         * The numeric identifier for the entity. This is a monotonically increasing id unique within this response
         * rather than a global unique identifier.
         * </p>
         * 
         * @param id
         *        The numeric identifier for the entity. This is a monotonically increasing id unique within this
         *        response rather than a global unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(Integer id);

        /**
         * <p>
         * The segment of input text that is matched to the detected entity.
         * </p>
         * 
         * @param text
         *        The segment of input text that is matched to the detected entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The category of the entity. InferICD10CM detects entities in the <code>MEDICAL_CONDITION</code> category.
         * </p>
         * 
         * @param category
         *        The category of the entity. InferICD10CM detects entities in the <code>MEDICAL_CONDITION</code>
         *        category.
         * @see ICD10CMEntityCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ICD10CMEntityCategory
         */
        Builder category(String category);

        /**
         * <p>
         * The category of the entity. InferICD10CM detects entities in the <code>MEDICAL_CONDITION</code> category.
         * </p>
         * 
         * @param category
         *        The category of the entity. InferICD10CM detects entities in the <code>MEDICAL_CONDITION</code>
         *        category.
         * @see ICD10CMEntityCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ICD10CMEntityCategory
         */
        Builder category(ICD10CMEntityCategory category);

        /**
         * <p>
         * Describes the specific type of entity with category of entities. InferICD10CM detects entities of the type
         * <code>DX_NAME</code> and <code>TIME_EXPRESSION</code>.
         * </p>
         * 
         * @param type
         *        Describes the specific type of entity with category of entities. InferICD10CM detects entities of the
         *        type <code>DX_NAME</code> and <code>TIME_EXPRESSION</code>.
         * @see ICD10CMEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ICD10CMEntityType
         */
        Builder type(String type);

        /**
         * <p>
         * Describes the specific type of entity with category of entities. InferICD10CM detects entities of the type
         * <code>DX_NAME</code> and <code>TIME_EXPRESSION</code>.
         * </p>
         * 
         * @param type
         *        Describes the specific type of entity with category of entities. InferICD10CM detects entities of the
         *        type <code>DX_NAME</code> and <code>TIME_EXPRESSION</code>.
         * @see ICD10CMEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ICD10CMEntityType
         */
        Builder type(ICD10CMEntityType type);

        /**
         * <p>
         * The level of confidence that Amazon Comprehend Medical has in the accuracy of the detection.
         * </p>
         * 
         * @param score
         *        The level of confidence that Amazon Comprehend Medical has in the accuracy of the detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Float score);

        /**
         * <p>
         * The 0-based character offset in the input text that shows where the entity begins. The offset returns the
         * UTF-8 code point in the string.
         * </p>
         * 
         * @param beginOffset
         *        The 0-based character offset in the input text that shows where the entity begins. The offset returns
         *        the UTF-8 code point in the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffset(Integer beginOffset);

        /**
         * <p>
         * The 0-based character offset in the input text that shows where the entity ends. The offset returns the UTF-8
         * code point in the string.
         * </p>
         * 
         * @param endOffset
         *        The 0-based character offset in the input text that shows where the entity ends. The offset returns
         *        the UTF-8 code point in the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffset(Integer endOffset);

        /**
         * <p>
         * The detected attributes that relate to the entity. An extracted segment of the text that is an attribute of
         * an entity, or otherwise related to an entity, such as the nature of a medical condition.
         * </p>
         * 
         * @param attributes
         *        The detected attributes that relate to the entity. An extracted segment of the text that is an
         *        attribute of an entity, or otherwise related to an entity, such as the nature of a medical condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<ICD10CMAttribute> attributes);

        /**
         * <p>
         * The detected attributes that relate to the entity. An extracted segment of the text that is an attribute of
         * an entity, or otherwise related to an entity, such as the nature of a medical condition.
         * </p>
         * 
         * @param attributes
         *        The detected attributes that relate to the entity. An extracted segment of the text that is an
         *        attribute of an entity, or otherwise related to an entity, such as the nature of a medical condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(ICD10CMAttribute... attributes);

        /**
         * <p>
         * The detected attributes that relate to the entity. An extracted segment of the text that is an attribute of
         * an entity, or otherwise related to an entity, such as the nature of a medical condition.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ICD10CMAttribute>.Builder} avoiding the
         * need to create one manually via {@link List<ICD10CMAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ICD10CMAttribute>.Builder#build()} is called immediately and
         * its result is passed to {@link #attributes(List<ICD10CMAttribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<ICD10CMAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<ICD10CMAttribute>)
         */
        Builder attributes(Consumer<ICD10CMAttribute.Builder>... attributes);

        /**
         * <p>
         * Provides Contextual information for the entity. The traits recognized by InferICD10CM are
         * <code>DIAGNOSIS</code>, <code>SIGN</code>, <code>SYMPTOM</code>, and <code>NEGATION.</code>
         * </p>
         * 
         * @param traits
         *        Provides Contextual information for the entity. The traits recognized by InferICD10CM are
         *        <code>DIAGNOSIS</code>, <code>SIGN</code>, <code>SYMPTOM</code>, and <code>NEGATION.</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traits(Collection<ICD10CMTrait> traits);

        /**
         * <p>
         * Provides Contextual information for the entity. The traits recognized by InferICD10CM are
         * <code>DIAGNOSIS</code>, <code>SIGN</code>, <code>SYMPTOM</code>, and <code>NEGATION.</code>
         * </p>
         * 
         * @param traits
         *        Provides Contextual information for the entity. The traits recognized by InferICD10CM are
         *        <code>DIAGNOSIS</code>, <code>SIGN</code>, <code>SYMPTOM</code>, and <code>NEGATION.</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traits(ICD10CMTrait... traits);

        /**
         * <p>
         * Provides Contextual information for the entity. The traits recognized by InferICD10CM are
         * <code>DIAGNOSIS</code>, <code>SIGN</code>, <code>SYMPTOM</code>, and <code>NEGATION.</code>
         * </p>
         * This is a convenience that creates an instance of the {@link List<ICD10CMTrait>.Builder} avoiding the need to
         * create one manually via {@link List<ICD10CMTrait>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ICD10CMTrait>.Builder#build()} is called immediately and its
         * result is passed to {@link #traits(List<ICD10CMTrait>)}.
         * 
         * @param traits
         *        a consumer that will call methods on {@link List<ICD10CMTrait>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traits(List<ICD10CMTrait>)
         */
        Builder traits(Consumer<ICD10CMTrait.Builder>... traits);

        /**
         * <p>
         * The ICD-10-CM concepts that the entity could refer to, along with a score indicating the likelihood of the
         * match.
         * </p>
         * 
         * @param icd10CMConcepts
         *        The ICD-10-CM concepts that the entity could refer to, along with a score indicating the likelihood of
         *        the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder icd10CMConcepts(Collection<ICD10CMConcept> icd10CMConcepts);

        /**
         * <p>
         * The ICD-10-CM concepts that the entity could refer to, along with a score indicating the likelihood of the
         * match.
         * </p>
         * 
         * @param icd10CMConcepts
         *        The ICD-10-CM concepts that the entity could refer to, along with a score indicating the likelihood of
         *        the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder icd10CMConcepts(ICD10CMConcept... icd10CMConcepts);

        /**
         * <p>
         * The ICD-10-CM concepts that the entity could refer to, along with a score indicating the likelihood of the
         * match.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ICD10CMConcept>.Builder} avoiding the need
         * to create one manually via {@link List<ICD10CMConcept>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ICD10CMConcept>.Builder#build()} is called immediately and
         * its result is passed to {@link #icd10CMConcepts(List<ICD10CMConcept>)}.
         * 
         * @param icd10CMConcepts
         *        a consumer that will call methods on {@link List<ICD10CMConcept>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #icd10CMConcepts(List<ICD10CMConcept>)
         */
        Builder icd10CMConcepts(Consumer<ICD10CMConcept.Builder>... icd10CMConcepts);
    }

    static final class BuilderImpl implements Builder {
        private Integer id;

        private String text;

        private String category;

        private String type;

        private Float score;

        private Integer beginOffset;

        private Integer endOffset;

        private List<ICD10CMAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private List<ICD10CMTrait> traits = DefaultSdkAutoConstructList.getInstance();

        private List<ICD10CMConcept> icd10CMConcepts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ICD10CMEntity model) {
            id(model.id);
            text(model.text);
            category(model.category);
            type(model.type);
            score(model.score);
            beginOffset(model.beginOffset);
            endOffset(model.endOffset);
            attributes(model.attributes);
            traits(model.traits);
            icd10CMConcepts(model.icd10CMConcepts);
        }

        public final Integer getId() {
            return id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        @Transient
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        @Transient
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        @Transient
        public final Builder category(ICD10CMEntityCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ICD10CMEntityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Float getScore() {
            return score;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        @Transient
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final Integer getBeginOffset() {
            return beginOffset;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        @Transient
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final Integer getEndOffset() {
            return endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        @Transient
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final List<ICD10CMAttribute.Builder> getAttributes() {
            List<ICD10CMAttribute.Builder> result = ICD10CMAttributeListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<ICD10CMAttribute.BuilderImpl> attributes) {
            this.attributes = ICD10CMAttributeListCopier.copyFromBuilder(attributes);
        }

        @Override
        @Transient
        public final Builder attributes(Collection<ICD10CMAttribute> attributes) {
            this.attributes = ICD10CMAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributes(ICD10CMAttribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributes(Consumer<ICD10CMAttribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> ICD10CMAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ICD10CMTrait.Builder> getTraits() {
            List<ICD10CMTrait.Builder> result = ICD10CMTraitListCopier.copyToBuilder(this.traits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTraits(Collection<ICD10CMTrait.BuilderImpl> traits) {
            this.traits = ICD10CMTraitListCopier.copyFromBuilder(traits);
        }

        @Override
        @Transient
        public final Builder traits(Collection<ICD10CMTrait> traits) {
            this.traits = ICD10CMTraitListCopier.copy(traits);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder traits(ICD10CMTrait... traits) {
            traits(Arrays.asList(traits));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder traits(Consumer<ICD10CMTrait.Builder>... traits) {
            traits(Stream.of(traits).map(c -> ICD10CMTrait.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ICD10CMConcept.Builder> getIcd10CMConcepts() {
            List<ICD10CMConcept.Builder> result = ICD10CMConceptListCopier.copyToBuilder(this.icd10CMConcepts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIcd10CMConcepts(Collection<ICD10CMConcept.BuilderImpl> icd10CMConcepts) {
            this.icd10CMConcepts = ICD10CMConceptListCopier.copyFromBuilder(icd10CMConcepts);
        }

        @Override
        @Transient
        public final Builder icd10CMConcepts(Collection<ICD10CMConcept> icd10CMConcepts) {
            this.icd10CMConcepts = ICD10CMConceptListCopier.copy(icd10CMConcepts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder icd10CMConcepts(ICD10CMConcept... icd10CMConcepts) {
            icd10CMConcepts(Arrays.asList(icd10CMConcepts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder icd10CMConcepts(Consumer<ICD10CMConcept.Builder>... icd10CMConcepts) {
            icd10CMConcepts(Stream.of(icd10CMConcepts).map(c -> ICD10CMConcept.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ICD10CMEntity build() {
            return new ICD10CMEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
