/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehendmedical.model.ICD10CMAttribute;
import software.amazon.awssdk.services.comprehendmedical.model.ICD10CMAttributeListCopier;
import software.amazon.awssdk.services.comprehendmedical.model.ICD10CMConcept;
import software.amazon.awssdk.services.comprehendmedical.model.ICD10CMConceptListCopier;
import software.amazon.awssdk.services.comprehendmedical.model.ICD10CMEntityCategory;
import software.amazon.awssdk.services.comprehendmedical.model.ICD10CMEntityType;
import software.amazon.awssdk.services.comprehendmedical.model.ICD10CMTrait;
import software.amazon.awssdk.services.comprehendmedical.model.ICD10CMTraitListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ICD10CMEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ICD10CMEntity> {
    private static final SdkField<Integer> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Id").getter(ICD10CMEntity.getter(ICD10CMEntity::id)).setter(ICD10CMEntity.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(ICD10CMEntity.getter(ICD10CMEntity::text)).setter(ICD10CMEntity.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(ICD10CMEntity.getter(ICD10CMEntity::categoryAsString)).setter(ICD10CMEntity.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ICD10CMEntity.getter(ICD10CMEntity::typeAsString)).setter(ICD10CMEntity.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Float> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Score").getter(ICD10CMEntity.getter(ICD10CMEntity::score)).setter(ICD10CMEntity.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BeginOffset").getter(ICD10CMEntity.getter(ICD10CMEntity::beginOffset)).setter(ICD10CMEntity.setter(Builder::beginOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()}).build();
    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndOffset").getter(ICD10CMEntity.getter(ICD10CMEntity::endOffset)).setter(ICD10CMEntity.setter(Builder::endOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()}).build();
    private static final SdkField<List<ICD10CMAttribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attributes").getter(ICD10CMEntity.getter(ICD10CMEntity::attributes)).setter(ICD10CMEntity.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ICD10CMAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ICD10CMTrait>> TRAITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Traits").getter(ICD10CMEntity.getter(ICD10CMEntity::traits)).setter(ICD10CMEntity.setter(Builder::traits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ICD10CMTrait::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ICD10CMConcept>> ICD10_CM_CONCEPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ICD10CMConcepts").getter(ICD10CMEntity.getter(ICD10CMEntity::icd10CMConcepts)).setter(ICD10CMEntity.setter(Builder::icd10CMConcepts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ICD10CMConcepts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ICD10CMConcept::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TEXT_FIELD, CATEGORY_FIELD, TYPE_FIELD, SCORE_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, ATTRIBUTES_FIELD, TRAITS_FIELD, ICD10_CM_CONCEPTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer id;
    private final String text;
    private final String category;
    private final String type;
    private final Float score;
    private final Integer beginOffset;
    private final Integer endOffset;
    private final List<ICD10CMAttribute> attributes;
    private final List<ICD10CMTrait> traits;
    private final List<ICD10CMConcept> icd10CMConcepts;

    private ICD10CMEntity(BuilderImpl builder) {
        this.id = builder.id;
        this.text = builder.text;
        this.category = builder.category;
        this.type = builder.type;
        this.score = builder.score;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.attributes = builder.attributes;
        this.traits = builder.traits;
        this.icd10CMConcepts = builder.icd10CMConcepts;
    }

    public final Integer id() {
        return this.id;
    }

    public final String text() {
        return this.text;
    }

    public final ICD10CMEntityCategory category() {
        return ICD10CMEntityCategory.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final ICD10CMEntityType type() {
        return ICD10CMEntityType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Float score() {
        return this.score;
    }

    public final Integer beginOffset() {
        return this.beginOffset;
    }

    public final Integer endOffset() {
        return this.endOffset;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<ICD10CMAttribute> attributes() {
        return this.attributes;
    }

    public final boolean hasTraits() {
        return this.traits != null && !(this.traits instanceof SdkAutoConstructList);
    }

    public final List<ICD10CMTrait> traits() {
        return this.traits;
    }

    public final boolean hasIcd10CMConcepts() {
        return this.icd10CMConcepts != null && !(this.icd10CMConcepts instanceof SdkAutoConstructList);
    }

    public final List<ICD10CMConcept> icd10CMConcepts() {
        return this.icd10CMConcepts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTraits() ? this.traits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIcd10CMConcepts() ? this.icd10CMConcepts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ICD10CMEntity)) {
            return false;
        }
        ICD10CMEntity other = (ICD10CMEntity)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.score(), other.score()) && Objects.equals(this.beginOffset(), other.beginOffset()) && Objects.equals(this.endOffset(), other.endOffset()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && this.hasTraits() == other.hasTraits() && Objects.equals(this.traits(), other.traits()) && this.hasIcd10CMConcepts() == other.hasIcd10CMConcepts() && Objects.equals(this.icd10CMConcepts(), other.icd10CMConcepts());
    }

    public final String toString() {
        return ToString.builder((String)"ICD10CMEntity").add("Id", (Object)this.id()).add("Text", (Object)this.text()).add("Category", (Object)this.categoryAsString()).add("Type", (Object)this.typeAsString()).add("Score", (Object)this.score()).add("BeginOffset", (Object)this.beginOffset()).add("EndOffset", (Object)this.endOffset()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Traits", this.hasTraits() ? this.traits() : null).add("ICD10CMConcepts", this.hasIcd10CMConcepts() ? this.icd10CMConcepts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "BeginOffset": {
                return Optional.ofNullable(clazz.cast(this.beginOffset()));
            }
            case "EndOffset": {
                return Optional.ofNullable(clazz.cast(this.endOffset()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "Traits": {
                return Optional.ofNullable(clazz.cast(this.traits()));
            }
            case "ICD10CMConcepts": {
                return Optional.ofNullable(clazz.cast(this.icd10CMConcepts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ICD10CMEntity, T> g) {
        return obj -> g.apply((ICD10CMEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer id;
        private String text;
        private String category;
        private String type;
        private Float score;
        private Integer beginOffset;
        private Integer endOffset;
        private List<ICD10CMAttribute> attributes = DefaultSdkAutoConstructList.getInstance();
        private List<ICD10CMTrait> traits = DefaultSdkAutoConstructList.getInstance();
        private List<ICD10CMConcept> icd10CMConcepts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ICD10CMEntity model) {
            this.id(model.id);
            this.text(model.text);
            this.category(model.category);
            this.type(model.type);
            this.score(model.score);
            this.beginOffset(model.beginOffset);
            this.endOffset(model.endOffset);
            this.attributes(model.attributes);
            this.traits(model.traits);
            this.icd10CMConcepts(model.icd10CMConcepts);
        }

        public final Integer getId() {
            return this.id;
        }

        @Override
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(ICD10CMEntityCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ICD10CMEntityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Float getScore() {
            return this.score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        public final Integer getBeginOffset() {
            return this.beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        public final Integer getEndOffset() {
            return this.endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        public final List<ICD10CMAttribute.Builder> getAttributes() {
            List<ICD10CMAttribute.Builder> result = ICD10CMAttributeListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder attributes(Collection<ICD10CMAttribute> attributes) {
            this.attributes = ICD10CMAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(ICD10CMAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<ICD10CMAttribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (ICD10CMAttribute)((ICD10CMAttribute.Builder)ICD10CMAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<ICD10CMAttribute.BuilderImpl> attributes) {
            this.attributes = ICD10CMAttributeListCopier.copyFromBuilder(attributes);
        }

        public final List<ICD10CMTrait.Builder> getTraits() {
            List<ICD10CMTrait.Builder> result = ICD10CMTraitListCopier.copyToBuilder(this.traits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder traits(Collection<ICD10CMTrait> traits) {
            this.traits = ICD10CMTraitListCopier.copy(traits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traits(ICD10CMTrait ... traits) {
            this.traits(Arrays.asList(traits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traits(Consumer<ICD10CMTrait.Builder> ... traits) {
            this.traits(Stream.of(traits).map(c -> (ICD10CMTrait)((ICD10CMTrait.Builder)ICD10CMTrait.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTraits(Collection<ICD10CMTrait.BuilderImpl> traits) {
            this.traits = ICD10CMTraitListCopier.copyFromBuilder(traits);
        }

        public final List<ICD10CMConcept.Builder> getIcd10CMConcepts() {
            List<ICD10CMConcept.Builder> result = ICD10CMConceptListCopier.copyToBuilder(this.icd10CMConcepts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder icd10CMConcepts(Collection<ICD10CMConcept> icd10CMConcepts) {
            this.icd10CMConcepts = ICD10CMConceptListCopier.copy(icd10CMConcepts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder icd10CMConcepts(ICD10CMConcept ... icd10CMConcepts) {
            this.icd10CMConcepts(Arrays.asList(icd10CMConcepts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder icd10CMConcepts(Consumer<ICD10CMConcept.Builder> ... icd10CMConcepts) {
            this.icd10CMConcepts(Stream.of(icd10CMConcepts).map(c -> (ICD10CMConcept)((ICD10CMConcept.Builder)ICD10CMConcept.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIcd10CMConcepts(Collection<ICD10CMConcept.BuilderImpl> icd10CMConcepts) {
            this.icd10CMConcepts = ICD10CMConceptListCopier.copyFromBuilder(icd10CMConcepts);
        }

        public ICD10CMEntity build() {
            return new ICD10CMEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ICD10CMEntity> {
        public Builder id(Integer var1);

        public Builder text(String var1);

        public Builder category(String var1);

        public Builder category(ICD10CMEntityCategory var1);

        public Builder type(String var1);

        public Builder type(ICD10CMEntityType var1);

        public Builder score(Float var1);

        public Builder beginOffset(Integer var1);

        public Builder endOffset(Integer var1);

        public Builder attributes(Collection<ICD10CMAttribute> var1);

        public Builder attributes(ICD10CMAttribute ... var1);

        public Builder attributes(Consumer<ICD10CMAttribute.Builder> ... var1);

        public Builder traits(Collection<ICD10CMTrait> var1);

        public Builder traits(ICD10CMTrait ... var1);

        public Builder traits(Consumer<ICD10CMTrait.Builder> ... var1);

        public Builder icd10CMConcepts(Collection<ICD10CMConcept> var1);

        public Builder icd10CMConcepts(ICD10CMConcept ... var1);

        public Builder icd10CMConcepts(Consumer<ICD10CMConcept.Builder> ... var1);
    }
}

