/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class RxNormAttributeListCopier {
    static List<RxNormAttribute> copy(Collection<RxNormAttribute> rxNormAttributeListParam) {
        if (rxNormAttributeListParam == null || rxNormAttributeListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<RxNormAttribute> rxNormAttributeListParamCopy = new ArrayList<>(rxNormAttributeListParam);
        return Collections.unmodifiableList(rxNormAttributeListParamCopy);
    }

    static List<RxNormAttribute> copyFromBuilder(Collection<? extends RxNormAttribute.Builder> rxNormAttributeListParam) {
        if (rxNormAttributeListParam == null || rxNormAttributeListParam instanceof DefaultSdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        return copy(rxNormAttributeListParam.stream().map(RxNormAttribute.Builder::build).collect(toList()));
    }
}
