/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehendmedical.model.RxNormAttributeType;
import software.amazon.awssdk.services.comprehendmedical.model.RxNormTrait;
import software.amazon.awssdk.services.comprehendmedical.model.RxNormTraitListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RxNormAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RxNormAttribute> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(RxNormAttribute.getter(RxNormAttribute::typeAsString)).setter(RxNormAttribute.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Float> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Score").getter(RxNormAttribute.getter(RxNormAttribute::score)).setter(RxNormAttribute.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final SdkField<Float> RELATIONSHIP_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("RelationshipScore").getter(RxNormAttribute.getter(RxNormAttribute::relationshipScore)).setter(RxNormAttribute.setter(Builder::relationshipScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelationshipScore").build()}).build();
    private static final SdkField<Integer> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Id").getter(RxNormAttribute.getter(RxNormAttribute::id)).setter(RxNormAttribute.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BeginOffset").getter(RxNormAttribute.getter(RxNormAttribute::beginOffset)).setter(RxNormAttribute.setter(Builder::beginOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()}).build();
    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndOffset").getter(RxNormAttribute.getter(RxNormAttribute::endOffset)).setter(RxNormAttribute.setter(Builder::endOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(RxNormAttribute.getter(RxNormAttribute::text)).setter(RxNormAttribute.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<List<RxNormTrait>> TRAITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Traits").getter(RxNormAttribute.getter(RxNormAttribute::traits)).setter(RxNormAttribute.setter(Builder::traits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RxNormTrait::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, SCORE_FIELD, RELATIONSHIP_SCORE_FIELD, ID_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, TEXT_FIELD, TRAITS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Float score;
    private final Float relationshipScore;
    private final Integer id;
    private final Integer beginOffset;
    private final Integer endOffset;
    private final String text;
    private final List<RxNormTrait> traits;

    private RxNormAttribute(BuilderImpl builder) {
        this.type = builder.type;
        this.score = builder.score;
        this.relationshipScore = builder.relationshipScore;
        this.id = builder.id;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.text = builder.text;
        this.traits = builder.traits;
    }

    public RxNormAttributeType type() {
        return RxNormAttributeType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Float score() {
        return this.score;
    }

    public Float relationshipScore() {
        return this.relationshipScore;
    }

    public Integer id() {
        return this.id;
    }

    public Integer beginOffset() {
        return this.beginOffset;
    }

    public Integer endOffset() {
        return this.endOffset;
    }

    public String text() {
        return this.text;
    }

    public boolean hasTraits() {
        return this.traits != null && !(this.traits instanceof SdkAutoConstructList);
    }

    public List<RxNormTrait> traits() {
        return this.traits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationshipScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.traits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RxNormAttribute)) {
            return false;
        }
        RxNormAttribute other = (RxNormAttribute)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.score(), other.score()) && Objects.equals(this.relationshipScore(), other.relationshipScore()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.beginOffset(), other.beginOffset()) && Objects.equals(this.endOffset(), other.endOffset()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.traits(), other.traits());
    }

    public String toString() {
        return ToString.builder((String)"RxNormAttribute").add("Type", (Object)this.typeAsString()).add("Score", (Object)this.score()).add("RelationshipScore", (Object)this.relationshipScore()).add("Id", (Object)this.id()).add("BeginOffset", (Object)this.beginOffset()).add("EndOffset", (Object)this.endOffset()).add("Text", (Object)this.text()).add("Traits", this.traits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "RelationshipScore": {
                return Optional.ofNullable(clazz.cast(this.relationshipScore()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "BeginOffset": {
                return Optional.ofNullable(clazz.cast(this.beginOffset()));
            }
            case "EndOffset": {
                return Optional.ofNullable(clazz.cast(this.endOffset()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "Traits": {
                return Optional.ofNullable(clazz.cast(this.traits()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RxNormAttribute, T> g) {
        return obj -> g.apply((RxNormAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Float score;
        private Float relationshipScore;
        private Integer id;
        private Integer beginOffset;
        private Integer endOffset;
        private String text;
        private List<RxNormTrait> traits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RxNormAttribute model) {
            this.type(model.type);
            this.score(model.score);
            this.relationshipScore(model.relationshipScore);
            this.id(model.id);
            this.beginOffset(model.beginOffset);
            this.endOffset(model.endOffset);
            this.text(model.text);
            this.traits(model.traits);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RxNormAttributeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Float getScore() {
            return this.score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        public final Float getRelationshipScore() {
            return this.relationshipScore;
        }

        @Override
        public final Builder relationshipScore(Float relationshipScore) {
            this.relationshipScore = relationshipScore;
            return this;
        }

        public final void setRelationshipScore(Float relationshipScore) {
            this.relationshipScore = relationshipScore;
        }

        public final Integer getId() {
            return this.id;
        }

        @Override
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getBeginOffset() {
            return this.beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        public final Integer getEndOffset() {
            return this.endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final Collection<RxNormTrait.Builder> getTraits() {
            return this.traits != null ? (Collection)this.traits.stream().map(RxNormTrait::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder traits(Collection<RxNormTrait> traits) {
            this.traits = RxNormTraitListCopier.copy(traits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traits(RxNormTrait ... traits) {
            this.traits(Arrays.asList(traits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traits(Consumer<RxNormTrait.Builder> ... traits) {
            this.traits(Stream.of(traits).map(c -> (RxNormTrait)((RxNormTrait.Builder)RxNormTrait.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTraits(Collection<RxNormTrait.BuilderImpl> traits) {
            this.traits = RxNormTraitListCopier.copyFromBuilder(traits);
        }

        public RxNormAttribute build() {
            return new RxNormAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RxNormAttribute> {
        public Builder type(String var1);

        public Builder type(RxNormAttributeType var1);

        public Builder score(Float var1);

        public Builder relationshipScore(Float var1);

        public Builder id(Integer var1);

        public Builder beginOffset(Integer var1);

        public Builder endOffset(Integer var1);

        public Builder text(String var1);

        public Builder traits(Collection<RxNormTrait> var1);

        public Builder traits(RxNormTrait ... var1);

        public Builder traits(Consumer<RxNormTrait.Builder> ... var1);
    }
}

