/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehendmedical.model.ComprehendMedicalResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ICD10CMEntity;
import software.amazon.awssdk.services.comprehendmedical.model.ICD10CMEntityListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferIcd10CmResponse
extends ComprehendMedicalResponse
implements ToCopyableBuilder<Builder, InferIcd10CmResponse> {
    private static final SdkField<List<ICD10CMEntity>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entities").getter(InferIcd10CmResponse.getter(InferIcd10CmResponse::entities)).setter(InferIcd10CmResponse.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ICD10CMEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaginationToken").getter(InferIcd10CmResponse.getter(InferIcd10CmResponse::paginationToken)).setter(InferIcd10CmResponse.setter(Builder::paginationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()}).build();
    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersion").getter(InferIcd10CmResponse.getter(InferIcd10CmResponse::modelVersion)).setter(InferIcd10CmResponse.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD, PAGINATION_TOKEN_FIELD, MODEL_VERSION_FIELD));
    private final List<ICD10CMEntity> entities;
    private final String paginationToken;
    private final String modelVersion;

    private InferIcd10CmResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.paginationToken = builder.paginationToken;
        this.modelVersion = builder.modelVersion;
    }

    public final boolean hasEntities() {
        return this.entities != null && !(this.entities instanceof SdkAutoConstructList);
    }

    public final List<ICD10CMEntity> entities() {
        return this.entities;
    }

    public final String paginationToken() {
        return this.paginationToken;
    }

    public final String modelVersion() {
        return this.modelVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntities() ? this.entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferIcd10CmResponse)) {
            return false;
        }
        InferIcd10CmResponse other = (InferIcd10CmResponse)((Object)obj);
        return this.hasEntities() == other.hasEntities() && Objects.equals(this.entities(), other.entities()) && Objects.equals(this.paginationToken(), other.paginationToken()) && Objects.equals(this.modelVersion(), other.modelVersion());
    }

    public final String toString() {
        return ToString.builder((String)"InferIcd10CmResponse").add("Entities", this.hasEntities() ? this.entities() : null).add("PaginationToken", (Object)this.paginationToken()).add("ModelVersion", (Object)this.modelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
            case "PaginationToken": {
                return Optional.ofNullable(clazz.cast(this.paginationToken()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferIcd10CmResponse, T> g) {
        return obj -> g.apply((InferIcd10CmResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendMedicalResponse.BuilderImpl
    implements Builder {
        private List<ICD10CMEntity> entities = DefaultSdkAutoConstructList.getInstance();
        private String paginationToken;
        private String modelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(InferIcd10CmResponse model) {
            super(model);
            this.entities(model.entities);
            this.paginationToken(model.paginationToken);
            this.modelVersion(model.modelVersion);
        }

        public final Collection<ICD10CMEntity.Builder> getEntities() {
            if (this.entities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entities != null ? (Collection)this.entities.stream().map(ICD10CMEntity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entities(Collection<ICD10CMEntity> entities) {
            this.entities = ICD10CMEntityListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(ICD10CMEntity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<ICD10CMEntity.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (ICD10CMEntity)((ICD10CMEntity.Builder)ICD10CMEntity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntities(Collection<ICD10CMEntity.BuilderImpl> entities) {
            this.entities = ICD10CMEntityListCopier.copyFromBuilder(entities);
        }

        public final String getPaginationToken() {
            return this.paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public InferIcd10CmResponse build() {
            return new InferIcd10CmResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendMedicalResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InferIcd10CmResponse> {
        public Builder entities(Collection<ICD10CMEntity> var1);

        public Builder entities(ICD10CMEntity ... var1);

        public Builder entities(Consumer<ICD10CMEntity.Builder> ... var1);

        public Builder paginationToken(String var1);

        public Builder modelVersion(String var1);
    }
}

