/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output properties for a detection job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputDataConfig.Builder, OutputDataConfig> {
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Bucket").getter(getter(OutputDataConfig::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()).build();

    private static final SdkField<String> S3_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Key")
            .getter(getter(OutputDataConfig::s3Key)).setter(setter(Builder::s3Key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Key").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(S3_BUCKET_FIELD, S3_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Bucket;

    private final String s3Key;

    private OutputDataConfig(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
    }

    /**
     * <p>
     * When you use the <code>OutputDataConfig</code> object with asynchronous operations, you specify the Amazon S3
     * location where you want to write the output data. The URI must be in the same region as the API endpoint that you
     * are calling. The location is used as the prefix for the actual location of the output.
     * </p>
     * 
     * @return When you use the <code>OutputDataConfig</code> object with asynchronous operations, you specify the
     *         Amazon S3 location where you want to write the output data. The URI must be in the same region as the API
     *         endpoint that you are calling. The location is used as the prefix for the actual location of the output.
     */
    public String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The path to the output data files in the S3 bucket. Amazon Comprehend Medical creates an output directory using
     * the job ID so that the output from one job does not overwrite the output of another.
     * </p>
     * 
     * @return The path to the output data files in the S3 bucket. Amazon Comprehend Medical creates an output directory
     *         using the job ID so that the output from one job does not overwrite the output of another.
     */
    public String s3Key() {
        return s3Key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3Key());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputDataConfig)) {
            return false;
        }
        OutputDataConfig other = (OutputDataConfig) obj;
        return Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(s3Key(), other.s3Key());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OutputDataConfig").add("S3Bucket", s3Bucket()).add("S3Key", s3Key()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "S3Key":
            return Optional.ofNullable(clazz.cast(s3Key()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputDataConfig, T> g) {
        return obj -> g.apply((OutputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputDataConfig> {
        /**
         * <p>
         * When you use the <code>OutputDataConfig</code> object with asynchronous operations, you specify the Amazon S3
         * location where you want to write the output data. The URI must be in the same region as the API endpoint that
         * you are calling. The location is used as the prefix for the actual location of the output.
         * </p>
         * 
         * @param s3Bucket
         *        When you use the <code>OutputDataConfig</code> object with asynchronous operations, you specify the
         *        Amazon S3 location where you want to write the output data. The URI must be in the same region as the
         *        API endpoint that you are calling. The location is used as the prefix for the actual location of the
         *        output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The path to the output data files in the S3 bucket. Amazon Comprehend Medical creates an output directory
         * using the job ID so that the output from one job does not overwrite the output of another.
         * </p>
         * 
         * @param s3Key
         *        The path to the output data files in the S3 bucket. Amazon Comprehend Medical creates an output
         *        directory using the job ID so that the output from one job does not overwrite the output of another.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Key(String s3Key);
    }

    static final class BuilderImpl implements Builder {
        private String s3Bucket;

        private String s3Key;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputDataConfig model) {
            s3Bucket(model.s3Bucket);
            s3Key(model.s3Key);
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        public OutputDataConfig build() {
            return new OutputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
