/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ICD10CMAttributeListCopier {
    static List<ICD10CMAttribute> copy(Collection<ICD10CMAttribute> icd10CMAttributeListParam) {
        if (icd10CMAttributeListParam == null || icd10CMAttributeListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<ICD10CMAttribute> icd10CMAttributeListParamCopy = new ArrayList<>(icd10CMAttributeListParam);
        return Collections.unmodifiableList(icd10CMAttributeListParamCopy);
    }

    static List<ICD10CMAttribute> copyFromBuilder(Collection<? extends ICD10CMAttribute.Builder> icd10CMAttributeListParam) {
        if (icd10CMAttributeListParam == null) {
            return null;
        }
        return copy(icd10CMAttributeListParam.stream().map(ICD10CMAttribute.Builder::build).collect(toList()));
    }
}
