/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferRxNormResponse extends ComprehendMedicalResponse implements
        ToCopyableBuilder<InferRxNormResponse.Builder, InferRxNormResponse> {
    private static final SdkField<List<RxNormEntity>> ENTITIES_FIELD = SdkField
            .<List<RxNormEntity>> builder(MarshallingType.LIST)
            .getter(getter(InferRxNormResponse::entities))
            .setter(setter(Builder::entities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RxNormEntity> builder(MarshallingType.SDK_POJO)
                                            .constructor(RxNormEntity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InferRxNormResponse::paginationToken)).setter(setter(Builder::paginationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()).build();

    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InferRxNormResponse::modelVersion)).setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD,
            PAGINATION_TOKEN_FIELD, MODEL_VERSION_FIELD));

    private final List<RxNormEntity> entities;

    private final String paginationToken;

    private final String modelVersion;

    private InferRxNormResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.paginationToken = builder.paginationToken;
        this.modelVersion = builder.modelVersion;
    }

    /**
     * Returns true if the Entities property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEntities() {
        return entities != null && !(entities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The medication entities detected in the text linked to RxNorm concepts. If the action is successful, the service
     * sends back an HTTP 200 response, as well as the entities detected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The medication entities detected in the text linked to RxNorm concepts. If the action is successful, the
     *         service sends back an HTTP 200 response, as well as the entities detected.
     */
    public List<RxNormEntity> entities() {
        return entities;
    }

    /**
     * <p>
     * If the result of the previous request to <code>InferRxNorm</code> was truncated, include the
     * <code>PaginationToken</code> to fetch the next page of medication entities.
     * </p>
     * 
     * @return If the result of the previous request to <code>InferRxNorm</code> was truncated, include the
     *         <code>PaginationToken</code> to fetch the next page of medication entities.
     */
    public String paginationToken() {
        return paginationToken;
    }

    /**
     * <p>
     * The version of the model used to analyze the documents, in the format <i>n</i>.<i>n</i>.<i>n</i> You can use this
     * information to track the model used for a particular batch of documents.
     * </p>
     * 
     * @return The version of the model used to analyze the documents, in the format <i>n</i>.<i>n</i>.<i>n</i> You can
     *         use this information to track the model used for a particular batch of documents.
     */
    public String modelVersion() {
        return modelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(entities());
        hashCode = 31 * hashCode + Objects.hashCode(paginationToken());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferRxNormResponse)) {
            return false;
        }
        InferRxNormResponse other = (InferRxNormResponse) obj;
        return Objects.equals(entities(), other.entities()) && Objects.equals(paginationToken(), other.paginationToken())
                && Objects.equals(modelVersion(), other.modelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InferRxNormResponse").add("Entities", entities()).add("PaginationToken", paginationToken())
                .add("ModelVersion", modelVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entities":
            return Optional.ofNullable(clazz.cast(entities()));
        case "PaginationToken":
            return Optional.ofNullable(clazz.cast(paginationToken()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferRxNormResponse, T> g) {
        return obj -> g.apply((InferRxNormResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendMedicalResponse.Builder, SdkPojo, CopyableBuilder<Builder, InferRxNormResponse> {
        /**
         * <p>
         * The medication entities detected in the text linked to RxNorm concepts. If the action is successful, the
         * service sends back an HTTP 200 response, as well as the entities detected.
         * </p>
         * 
         * @param entities
         *        The medication entities detected in the text linked to RxNorm concepts. If the action is successful,
         *        the service sends back an HTTP 200 response, as well as the entities detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Collection<RxNormEntity> entities);

        /**
         * <p>
         * The medication entities detected in the text linked to RxNorm concepts. If the action is successful, the
         * service sends back an HTTP 200 response, as well as the entities detected.
         * </p>
         * 
         * @param entities
         *        The medication entities detected in the text linked to RxNorm concepts. If the action is successful,
         *        the service sends back an HTTP 200 response, as well as the entities detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(RxNormEntity... entities);

        /**
         * <p>
         * The medication entities detected in the text linked to RxNorm concepts. If the action is successful, the
         * service sends back an HTTP 200 response, as well as the entities detected.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RxNormEntity>.Builder} avoiding the need to
         * create one manually via {@link List<RxNormEntity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RxNormEntity>.Builder#build()} is called immediately and its
         * result is passed to {@link #entities(List<RxNormEntity>)}.
         * 
         * @param entities
         *        a consumer that will call methods on {@link List<RxNormEntity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(List<RxNormEntity>)
         */
        Builder entities(Consumer<RxNormEntity.Builder>... entities);

        /**
         * <p>
         * If the result of the previous request to <code>InferRxNorm</code> was truncated, include the
         * <code>PaginationToken</code> to fetch the next page of medication entities.
         * </p>
         * 
         * @param paginationToken
         *        If the result of the previous request to <code>InferRxNorm</code> was truncated, include the
         *        <code>PaginationToken</code> to fetch the next page of medication entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginationToken(String paginationToken);

        /**
         * <p>
         * The version of the model used to analyze the documents, in the format <i>n</i>.<i>n</i>.<i>n</i> You can use
         * this information to track the model used for a particular batch of documents.
         * </p>
         * 
         * @param modelVersion
         *        The version of the model used to analyze the documents, in the format <i>n</i>.<i>n</i>.<i>n</i> You
         *        can use this information to track the model used for a particular batch of documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);
    }

    static final class BuilderImpl extends ComprehendMedicalResponse.BuilderImpl implements Builder {
        private List<RxNormEntity> entities = DefaultSdkAutoConstructList.getInstance();

        private String paginationToken;

        private String modelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(InferRxNormResponse model) {
            super(model);
            entities(model.entities);
            paginationToken(model.paginationToken);
            modelVersion(model.modelVersion);
        }

        public final Collection<RxNormEntity.Builder> getEntities() {
            return entities != null ? entities.stream().map(RxNormEntity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entities(Collection<RxNormEntity> entities) {
            this.entities = RxNormEntityListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(RxNormEntity... entities) {
            entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<RxNormEntity.Builder>... entities) {
            entities(Stream.of(entities).map(c -> RxNormEntity.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntities(Collection<RxNormEntity.BuilderImpl> entities) {
            this.entities = RxNormEntityListCopier.copyFromBuilder(entities);
        }

        public final String getPaginationToken() {
            return paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public InferRxNormResponse build() {
            return new InferRxNormResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
