/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contextual information for the entity. The traits recognized by InferICD10CM are <code>DIAGNOSIS</code>,
 * <code>SIGN</code>, <code>SYMPTOM</code>, and <code>NEGATION</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ICD10CMTrait implements SdkPojo, Serializable, ToCopyableBuilder<ICD10CMTrait.Builder, ICD10CMTrait> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ICD10CMTrait::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Float> SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(ICD10CMTrait::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Float score;

    private ICD10CMTrait(BuilderImpl builder) {
        this.name = builder.name;
        this.score = builder.score;
    }

    /**
     * <p>
     * Provides a name or contextual description about the trait.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ICD10CMTraitName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Provides a name or contextual description about the trait.
     * @see ICD10CMTraitName
     */
    public ICD10CMTraitName name() {
        return ICD10CMTraitName.fromValue(name);
    }

    /**
     * <p>
     * Provides a name or contextual description about the trait.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ICD10CMTraitName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Provides a name or contextual description about the trait.
     * @see ICD10CMTraitName
     */
    public String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The level of confidence that Amazon Comprehend Medical has that the segment of text is correctly recognized as a
     * trait.
     * </p>
     * 
     * @return The level of confidence that Amazon Comprehend Medical has that the segment of text is correctly
     *         recognized as a trait.
     */
    public Float score() {
        return score;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ICD10CMTrait)) {
            return false;
        }
        ICD10CMTrait other = (ICD10CMTrait) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(score(), other.score());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ICD10CMTrait").add("Name", nameAsString()).add("Score", score()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ICD10CMTrait, T> g) {
        return obj -> g.apply((ICD10CMTrait) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ICD10CMTrait> {
        /**
         * <p>
         * Provides a name or contextual description about the trait.
         * </p>
         * 
         * @param name
         *        Provides a name or contextual description about the trait.
         * @see ICD10CMTraitName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ICD10CMTraitName
         */
        Builder name(String name);

        /**
         * <p>
         * Provides a name or contextual description about the trait.
         * </p>
         * 
         * @param name
         *        Provides a name or contextual description about the trait.
         * @see ICD10CMTraitName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ICD10CMTraitName
         */
        Builder name(ICD10CMTraitName name);

        /**
         * <p>
         * The level of confidence that Amazon Comprehend Medical has that the segment of text is correctly recognized
         * as a trait.
         * </p>
         * 
         * @param score
         *        The level of confidence that Amazon Comprehend Medical has that the segment of text is correctly
         *        recognized as a trait.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Float score);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Float score;

        private BuilderImpl() {
        }

        private BuilderImpl(ICD10CMTrait model) {
            name(model.name);
            score(model.score);
        }

        public final String getNameAsString() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ICD10CMTraitName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Float getScore() {
            return score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        public ICD10CMTrait build() {
            return new ICD10CMTrait(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
