/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityRecognizerEvaluationMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityRecognizerEvaluationMetrics> {
    private static final SdkField<Double> PRECISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(EntityRecognizerEvaluationMetrics.getter(EntityRecognizerEvaluationMetrics::precision)).setter(EntityRecognizerEvaluationMetrics.setter(Builder::precision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Precision").build()}).build();
    private static final SdkField<Double> RECALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(EntityRecognizerEvaluationMetrics.getter(EntityRecognizerEvaluationMetrics::recall)).setter(EntityRecognizerEvaluationMetrics.setter(Builder::recall)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recall").build()}).build();
    private static final SdkField<Double> F1_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(EntityRecognizerEvaluationMetrics.getter(EntityRecognizerEvaluationMetrics::f1Score)).setter(EntityRecognizerEvaluationMetrics.setter(Builder::f1Score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("F1Score").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRECISION_FIELD, RECALL_FIELD, F1_SCORE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double precision;
    private final Double recall;
    private final Double f1Score;

    private EntityRecognizerEvaluationMetrics(BuilderImpl builder) {
        this.precision = builder.precision;
        this.recall = builder.recall;
        this.f1Score = builder.f1Score;
    }

    public Double precision() {
        return this.precision;
    }

    public Double recall() {
        return this.recall;
    }

    public Double f1Score() {
        return this.f1Score;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.precision());
        hashCode = 31 * hashCode + Objects.hashCode(this.recall());
        hashCode = 31 * hashCode + Objects.hashCode(this.f1Score());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognizerEvaluationMetrics)) {
            return false;
        }
        EntityRecognizerEvaluationMetrics other = (EntityRecognizerEvaluationMetrics)obj;
        return Objects.equals(this.precision(), other.precision()) && Objects.equals(this.recall(), other.recall()) && Objects.equals(this.f1Score(), other.f1Score());
    }

    public String toString() {
        return ToString.builder((String)"EntityRecognizerEvaluationMetrics").add("Precision", (Object)this.precision()).add("Recall", (Object)this.recall()).add("F1Score", (Object)this.f1Score()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Precision": {
                return Optional.ofNullable(clazz.cast(this.precision()));
            }
            case "Recall": {
                return Optional.ofNullable(clazz.cast(this.recall()));
            }
            case "F1Score": {
                return Optional.ofNullable(clazz.cast(this.f1Score()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityRecognizerEvaluationMetrics, T> g) {
        return obj -> g.apply((EntityRecognizerEvaluationMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double precision;
        private Double recall;
        private Double f1Score;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityRecognizerEvaluationMetrics model) {
            this.precision(model.precision);
            this.recall(model.recall);
            this.f1Score(model.f1Score);
        }

        public final Double getPrecision() {
            return this.precision;
        }

        @Override
        public final Builder precision(Double precision) {
            this.precision = precision;
            return this;
        }

        public final void setPrecision(Double precision) {
            this.precision = precision;
        }

        public final Double getRecall() {
            return this.recall;
        }

        @Override
        public final Builder recall(Double recall) {
            this.recall = recall;
            return this;
        }

        public final void setRecall(Double recall) {
            this.recall = recall;
        }

        public final Double getF1Score() {
            return this.f1Score;
        }

        @Override
        public final Builder f1Score(Double f1Score) {
            this.f1Score = f1Score;
            return this;
        }

        public final void setF1Score(Double f1Score) {
            this.f1Score = f1Score;
        }

        public EntityRecognizerEvaluationMetrics build() {
            return new EntityRecognizerEvaluationMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityRecognizerEvaluationMetrics> {
        public Builder precision(Double var1);

        public Builder recall(Double var1);

        public Builder f1Score(Double var1);
    }
}

